/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import nc.capability.radiation.IEntityRads;
import nc.capability.radiation.IRadiation;
import nc.config.NCConfig;
import nc.init.NCItems;
import nc.util.GuiHelper;
import nc.util.RadiationHelper;
import nc.util.TextHelper;
import nc.util.UnitHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RadiationOverlayHandler
extends Gui {
    private final Minecraft mc;
    private static final ResourceLocation RADS_BAR = new ResourceLocation("nuclearcraft:textures/hud/rads_bar.png");

    public RadiationOverlayHandler(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void addRadiationInfo(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        EntityPlayerSP player = this.mc.field_71439_g;
        if (NCConfig.radiation_require_counter && !player.field_71071_by.func_70431_c(new ItemStack(NCItems.geiger_counter)) || !player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            return;
        }
        IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
        if (playerRads == null) {
            return;
        }
        ScaledResolution res = new ScaledResolution(this.mc);
        int barWidth = (int)(100.0 * playerRads.getTotalRads() / playerRads.getMaxRads());
        String info = playerRads.isRadiationNegligible() ? "0 Rads/t" : UnitHelper.prefix(playerRads.getRadiationLevel(), 3, "Rads/t", 0, -8);
        int infoWidth = this.mc.field_71466_p.func_78256_a(info);
        int overlayWidth = (int)Math.round((double)Math.max(104, infoWidth) * NCConfig.radiation_hud_size);
        int overlayHeight = (int)Math.round(19.0 * NCConfig.radiation_hud_size);
        int xPos = (int)Math.round(NCConfig.radiation_hud_position_cartesian.length >= 2 ? NCConfig.radiation_hud_position_cartesian[0] * (double)res.func_78326_a() : (double)GuiHelper.getRenderPositionXFromAngle(res, NCConfig.radiation_hud_position, overlayWidth, 3) / NCConfig.radiation_hud_size);
        int yPos = (int)Math.round(NCConfig.radiation_hud_position_cartesian.length >= 2 ? NCConfig.radiation_hud_position_cartesian[1] * (double)res.func_78328_b() : (double)GuiHelper.getRenderPositionYFromAngle(res, NCConfig.radiation_hud_position, overlayHeight, 3) / NCConfig.radiation_hud_size);
        this.mc.func_110434_K().func_110577_a(RADS_BAR);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)NCConfig.radiation_hud_size, (double)NCConfig.radiation_hud_size, (double)1.0);
        this.func_73729_b(xPos, yPos, 0, 0, 104, 10);
        this.func_73729_b(xPos + 2 + 100 - barWidth, yPos + 2, 100 - barWidth, 10, barWidth, 6);
        this.mc.field_71466_p.func_78276_b(info, xPos + (104 - infoWidth) / 2, yPos += 12, TextHelper.getFormatColor(RadiationHelper.getRadiationTextColor((IRadiation)playerRads)));
        GlStateManager.func_179121_F();
    }
}

