/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.energy.battery;

import nc.config.NCConfig;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energy.IEnergySpread;
import nc.tile.energy.ITileEnergy;
import nc.tile.energy.TileEnergy;
import nc.tile.energy.battery.BatteryType;
import nc.tile.energy.battery.IBattery;
import nc.tile.internal.energy.EnergyConnection;
import nc.util.BlockFinder;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;

public class TileBattery
extends TileEnergy
implements IBattery,
IInterfaceable,
IEnergySpread {
    private final BatteryType type;
    private BlockFinder finder;
    protected int batteryCount = 0;
    protected int comparatorStrength = 0;

    public TileBattery(BatteryType type) {
        super(type.getCapacity(), type.getMaxTransfer(), ITileEnergy.energyConnectionAll(EnergyConnection.IN));
        this.type = type;
    }

    @Override
    public void onAdded() {
        this.finder = new BlockFinder(this.field_174879_c, this.field_145850_b, this.func_145832_p());
        super.onAdded();
        this.batteryCount = -1;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.pushEnergy();
            if (this.batteryCount == 0) {
                this.spreadEnergy();
            }
            this.tickBattery();
            boolean shouldUpdate = false;
            if (this.comparatorStrength != this.getComparatorStrength() && this.findAdjacentComparator()) {
                shouldUpdate = true;
            }
            this.comparatorStrength = this.getComparatorStrength();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public int getComparatorStrength() {
        return (int)Math.round(15.0 * (double)this.getEnergyStored() / (double)this.getMaxEnergyStored());
    }

    public boolean findAdjacentComparator() {
        return this.finder.adjacent(this.field_174879_c, 1, Blocks.field_150441_bU, Blocks.field_150455_bV);
    }

    public void tickBattery() {
        ++this.batteryCount;
        this.batteryCount %= NCConfig.machine_update_rate;
    }

    @Override
    public int getEUSourceTier() {
        return this.type.getEnergyTier();
    }

    @Override
    public int getEUSinkTier() {
        return this.type.getEnergyTier();
    }

    @Override
    public boolean hasConfigurableEnergyConnections() {
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("comparatorStrength", this.comparatorStrength);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.comparatorStrength = nbt.func_74762_e("comparatorStrength");
    }

    public static class LithiumIonBatteryElite
    extends TileBattery {
        public LithiumIonBatteryElite() {
            super(BatteryType.LITHIUM_ION_BATTERY_ELITE);
        }
    }

    public static class LithiumIonBatteryDU
    extends TileBattery {
        public LithiumIonBatteryDU() {
            super(BatteryType.LITHIUM_ION_BATTERY_DU);
        }
    }

    public static class LithiumIonBatteryAdvanced
    extends TileBattery {
        public LithiumIonBatteryAdvanced() {
            super(BatteryType.LITHIUM_ION_BATTERY_ADVANCED);
        }
    }

    public static class LithiumIonBatteryBasic
    extends TileBattery {
        public LithiumIonBatteryBasic() {
            super(BatteryType.LITHIUM_ION_BATTERY_BASIC);
        }
    }

    public static class VoltaicPileElite
    extends TileBattery {
        public VoltaicPileElite() {
            super(BatteryType.VOLTAIC_PILE_ELITE);
        }
    }

    public static class VoltaicPileDU
    extends TileBattery {
        public VoltaicPileDU() {
            super(BatteryType.VOLTAIC_PILE_DU);
        }
    }

    public static class VoltaicPileAdvanced
    extends TileBattery {
        public VoltaicPileAdvanced() {
            super(BatteryType.VOLTAIC_PILE_ADVANCED);
        }
    }

    public static class VoltaicPileBasic
    extends TileBattery {
        public VoltaicPileBasic() {
            super(BatteryType.VOLTAIC_PILE_BASIC);
        }
    }
}

