/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.builder.BlockFlags;
import mcjty.lib.builder.GenericBlockBuilder;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.ItemStackTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.ModBlocks;
import mcjty.rftools.blocks.builder.BuilderRenderer;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.blocks.builder.GuiBuilder;
import mcjty.rftools.blocks.builder.SpaceChamberBlock;
import mcjty.rftools.blocks.builder.SpaceChamberControllerBlock;
import mcjty.rftools.blocks.builder.SupportBlock;
import mcjty.rftools.blocks.shaper.ComposerTileEntity;
import mcjty.rftools.blocks.shaper.GuiComposer;
import mcjty.rftools.blocks.shaper.GuiLocator;
import mcjty.rftools.blocks.shaper.GuiProjector;
import mcjty.rftools.blocks.shaper.GuiScanner;
import mcjty.rftools.blocks.shaper.LocatorTileEntity;
import mcjty.rftools.blocks.shaper.ProjectorRenderer;
import mcjty.rftools.blocks.shaper.ProjectorTileEntity;
import mcjty.rftools.blocks.shaper.RemoteScannerTileEntity;
import mcjty.rftools.blocks.shaper.ScannerTileEntity;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.items.builder.SpaceChamberCardItem;
import net.minecraft.block.Block;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BuilderSetup {
    public static SpaceChamberBlock spaceChamberBlock;
    public static SpaceChamberControllerBlock spaceChamberControllerBlock;
    public static SupportBlock supportBlock;
    public static GenericBlock<ComposerTileEntity, GenericContainer> composerBlock;
    public static GenericBlock<ScannerTileEntity, GenericContainer> scannerBlock;
    public static GenericBlock<RemoteScannerTileEntity, GenericContainer> remoteScannerBlock;
    public static GenericBlock<ProjectorTileEntity, GenericContainer> projectorBlock;
    public static GenericBlock<LocatorTileEntity, GenericContainer> locatorBlock;
    public static GenericBlock<BuilderTileEntity, GenericContainer> builderBlock;
    public static SpaceChamberCardItem spaceChamberCardItem;
    public static ShapeCardItem shapeCardItem;
    private static Map<String, BlockInformation> blockInformationMap;

    public static void init() {
        spaceChamberBlock = new SpaceChamberBlock();
        spaceChamberControllerBlock = new SpaceChamberControllerBlock();
        supportBlock = new SupportBlock();
        builderBlock = ((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)ModBlocks.builderFactory.builder("builder").tileEntityClass(BuilderTileEntity.class).container(BuilderTileEntity.CONTAINER_FACTORY).flags(new BlockFlags[]{BlockFlags.REDSTONE_CHECK})).rotationType(BaseBlock.RotationType.HORIZROTATION)).moduleSupport((IModuleSupport)BuilderTileEntity.MODULE_SUPPORT).guiId(RFTools.GUI_BUILDER).infusable().info("message.rftools.shiftmessage")).infoExtended("message.rftools.builder")).build();
        composerBlock = ((GenericBlockBuilder)((GenericBlockBuilder)ModBlocks.builderFactory.builder("composer").tileEntityClass(ComposerTileEntity.class).container(ComposerTileEntity.CONTAINER_FACTORY).guiId(RFTools.GUI_COMPOSER).info("message.rftools.shiftmessage")).infoExtended("message.rftools.composer")).build();
        locatorBlock = ((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)ModBlocks.builderFactory.builder("locator").tileEntityClass(LocatorTileEntity.class).flags(new BlockFlags[]{BlockFlags.REDSTONE_CHECK})).emptyContainer().guiId(RFTools.GUI_LOCATOR).info("message.rftools.shiftmessage")).infoExtended("message.rftools.locator")).build();
        projectorBlock = ((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)ModBlocks.builderFactory.builder("projector").tileEntityClass(ProjectorTileEntity.class).flags(new BlockFlags[]{BlockFlags.REDSTONE_CHECK})).rotationType(BaseBlock.RotationType.HORIZROTATION)).container(ProjectorTileEntity.CONTAINER_FACTORY).guiId(RFTools.GUI_PROJECTOR).info("message.rftools.shiftmessage")).infoExtended("message.rftools.projector")).build();
        scannerBlock = ((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)ModBlocks.builderFactory.builder("scanner").tileEntityClass(ScannerTileEntity.class).flags(new BlockFlags[]{BlockFlags.REDSTONE_CHECK})).container(ScannerTileEntity.CONTAINER_FACTORY).guiId(RFTools.GUI_SCANNER).info("message.rftools.shiftmessage")).infoExtended("message.rftools.scanner")).infoExtendedParameter(ItemStackTools.intGetter((String)"scanid", (Integer)-1))).build();
        remoteScannerBlock = ((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)((GenericBlockBuilder)ModBlocks.builderFactory.builder("remote_scanner").tileEntityClass(RemoteScannerTileEntity.class).flags(new BlockFlags[]{BlockFlags.REDSTONE_CHECK})).container(ScannerTileEntity.CONTAINER_FACTORY).guiId(RFTools.GUI_SCANNER).info("message.rftools.shiftmessage")).infoExtended("message.rftools.remote_scanner")).infoExtendedParameter(ItemStackTools.intGetter((String)"scanid", (Integer)-1))).build();
        BuilderSetup.initItems();
        BuilderSetup.readBuilderBlocksInternal();
        BuilderSetup.readBuilderBlocksConfig();
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        spaceChamberBlock.initModel();
        spaceChamberControllerBlock.initModel();
        builderBlock.initModel();
        builderBlock.setGuiFactory(GuiBuilder::new);
        BuilderRenderer.register();
        supportBlock.initModel();
        composerBlock.initModel();
        composerBlock.setGuiFactory(GuiComposer::new);
        scannerBlock.initModel();
        scannerBlock.setGuiFactory(GuiScanner::new);
        remoteScannerBlock.initModel();
        remoteScannerBlock.setGuiFactory(GuiScanner::new);
        projectorBlock.initModel();
        projectorBlock.setGuiFactory(GuiProjector::new);
        ProjectorRenderer.register();
        locatorBlock.initModel();
        locatorBlock.setGuiFactory(GuiLocator::new);
        spaceChamberCardItem.initModel();
        shapeCardItem.initModel();
    }

    private static void initItems() {
        spaceChamberCardItem = new SpaceChamberCardItem();
        shapeCardItem = new ShapeCardItem();
    }

    private static void readBuilderBlocksInternal() {
        try (InputStream inputstream = RFTools.class.getResourceAsStream("/assets/rftools/text/builder.json");){
            BuilderSetup.parseBuilderJson(inputstream);
        }
        catch (IOException e) {
            Logging.logError((String)"Error reading builder.json", (Throwable)e);
        }
    }

    private static void readBuilderBlocksConfig() {
        File modConfigDir = RFTools.proxy.modConfigDir;
        File file = new File(modConfigDir.getPath() + File.separator + "rftools", "userbuilder.json");
        try (FileInputStream inputstream = new FileInputStream(file);){
            BuilderSetup.parseBuilderJson(inputstream);
        }
        catch (IOException e) {
            Logging.log((String)"Could not read 'userbuilder.json', this is not an error!");
        }
    }

    private static void parseBuilderJson(InputStream inputstream) throws UnsupportedEncodingException {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)br);
        for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
            if ("movables".equals(entry.getKey())) {
                BuilderSetup.readMovablesFromJson((JsonElement)entry.getValue());
                continue;
            }
            if (!"rotatables".equals(entry.getKey())) continue;
            BuilderSetup.readRotatablesFromJson((JsonElement)entry.getValue());
        }
    }

    private static void readMovablesFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            String blockName = entry.getAsJsonArray().get(0).getAsString();
            String warningType = entry.getAsJsonArray().get(1).getAsString();
            double costFactor = entry.getAsJsonArray().get(2).getAsDouble();
            int status = "-".equals(warningType) ? 2 : ("+".equals(warningType) ? 0 : 1);
            BlockInformation old = blockInformationMap.get(blockName);
            if (old == null) {
                old = BlockInformation.OK;
            }
            blockInformationMap.put(blockName, new BlockInformation(old, blockName, status, costFactor));
        }
    }

    private static void readRotatablesFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            String blockName = entry.getAsJsonArray().get(0).getAsString();
            String rotatable = entry.getAsJsonArray().get(1).getAsString();
            BlockInformation old = blockInformationMap.get(blockName);
            if (old == null) {
                old = BlockInformation.OK;
            }
            blockInformationMap.put(blockName, new BlockInformation(old, rotatable));
        }
    }

    public static BlockInformation getBlockInformation(Block block) {
        BlockInformation information = blockInformationMap.get(block.getRegistryName().toString());
        if (information == null) {
            String modid = BlockTools.getModidForBlock((Block)block);
            information = blockInformationMap.get("modid:" + modid);
        }
        return information;
    }

    static {
        blockInformationMap = new HashMap<String, BlockInformation>();
    }

    public static class BlockInformation {
        private final String blockName;
        private final int blockLevel;
        private final double costFactor;
        private final int rotateInfo;
        public static final int ROTATE_invalid = -1;
        public static final int ROTATE_mmmm = 0;
        public static final int ROTATE_mfff = 1;
        public static final BlockInformation INVALID = new BlockInformation("", 2, 1.0);
        public static final BlockInformation OK = new BlockInformation("", 0, 1.0, 0);
        public static final BlockInformation FREE = new BlockInformation("", 0, 0.0, 0);

        private static int rotateStringToId(String rotateString) {
            if ("mmmm".equals(rotateString)) {
                return 0;
            }
            if ("mfff".equals(rotateString)) {
                return 1;
            }
            return -1;
        }

        public BlockInformation(String blockName, int blockLevel, double costFactor) {
            this.blockName = blockName;
            this.blockLevel = blockLevel;
            this.costFactor = costFactor;
            this.rotateInfo = 0;
        }

        public BlockInformation(String blockName, int blockLevel, double costFactor, int rotateInfo) {
            this.blockName = blockName;
            this.blockLevel = blockLevel;
            this.costFactor = costFactor;
            this.rotateInfo = rotateInfo;
        }

        public BlockInformation(BlockInformation other, String rotateInfo) {
            this(other.blockName, other.blockLevel, other.costFactor, BlockInformation.rotateStringToId(rotateInfo));
        }

        public BlockInformation(BlockInformation other, String blockName, int blockLevel, double costFactor) {
            this(blockName, blockLevel, costFactor, other.rotateInfo);
        }

        public int getBlockLevel() {
            return this.blockLevel;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public double getCostFactor() {
            return this.costFactor;
        }

        public int getRotateInfo() {
            return this.rotateInfo;
        }
    }
}

