/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.PacketListFromServer;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shield.filters.AbstractShieldFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketFiltersReady
extends PacketListFromServer<PacketFiltersReady, ShieldFilter> {
    public PacketFiltersReady() {
    }

    public PacketFiltersReady(BlockPos pos, String command, List<ShieldFilter> list) {
        super(pos, command, list);
    }

    protected ShieldFilter createItem(ByteBuf buf) {
        return AbstractShieldFilter.createFilter(buf);
    }

    protected void writeItemToBuf(ByteBuf buf, ShieldFilter item) {
        item.toBytes(buf);
    }

    public static class Handler
    implements IMessageHandler<PacketFiltersReady, IMessage> {
        public IMessage onMessage(PacketFiltersReady message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketFiltersReady message, MessageContext ctx) {
            TileEntity te = RFTools.proxy.getClientWorld().func_175625_s(message.pos);
            if (!(te instanceof IClientCommandHandler)) {
                Logging.log((String)"createInventoryReadyPacket: TileEntity is not a ClientCommandHandler!");
                return;
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(message.command, message.list, Type.create(ShieldFilter.class))) {
                Logging.log((String)("Command " + message.command + " was not handled!"));
            }
        }
    }
}

