/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory;

import extracells.integration.Integration;
import extracells.inventory.InventoryPlain;
import extracells.item.ItemGas;
import extracells.registries.ItemEnum;
import extracells.util.GasUtil;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;

public class ECGasFilterInventory
extends InventoryPlain {
    private final ItemStack cellItem;

    public ECGasFilterInventory(String customName, int size, ItemStack cellItem) {
        super(customName, size, 1);
        this.cellItem = cellItem;
        if (this.cellItem.func_77942_o() && this.cellItem.func_77978_p().func_74764_b("filter")) {
            this.readFromNBT(this.cellItem.func_77978_p().func_150295_c("filter", 10));
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack itemStack) {
        if (Integration.Mods.MEKANISMGAS.isEnabled()) {
            return this.isItemValidForSlotGas(index, itemStack);
        }
        return false;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public boolean isItemValidForSlotGas(int index, ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        if (itemStack.func_77973_b() == ItemEnum.GASITEM.getItem()) {
            String gasName = ItemGas.getGasName(itemStack);
            for (ItemStack slotStack : this.slots) {
                String itemGasName;
                if (slotStack == null || slotStack.func_190926_b() || !(itemGasName = ItemGas.getGasName(slotStack)).equals(gasName)) continue;
                return false;
            }
            return true;
        }
        GasStack stack = GasUtil.getGasFromContainer(itemStack);
        if (stack == null) {
            return false;
        }
        String gasName = stack.getGas().getName();
        for (ItemStack slotStack : this.slots) {
            String itemGasName;
            if (slotStack == null || slotStack.func_190926_b() || !(itemGasName = ItemGas.getGasName(slotStack)).equals(gasName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void func_70296_d() {
        NBTTagCompound tag = this.cellItem.func_77942_o() ? this.cellItem.func_77978_p() : new NBTTagCompound();
        tag.func_74782_a("filter", (NBTBase)this.writeToNBT());
    }

    @Override
    public void func_70299_a(int index, ItemStack itemStack) {
        if (Integration.Mods.MEKANISMGAS.isEnabled()) {
            this.setInventorySlotContentsGas(index, itemStack);
        } else {
            super.func_70299_a(index, ItemStack.field_190927_a);
        }
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public void setInventorySlotContentsGas(int index, ItemStack itemStack) {
        Gas gas;
        if (itemStack == null || itemStack.func_190926_b()) {
            super.func_70299_a(index, ItemStack.field_190927_a);
            return;
        }
        if (itemStack.func_77973_b() == ItemEnum.GASITEM.getItem()) {
            gas = GasRegistry.getGas((String)ItemGas.getGasName(itemStack));
            if (gas == null) {
                return;
            }
        } else {
            if (!this.func_94041_b(index, itemStack)) {
                return;
            }
            GasStack gasStack = GasUtil.getGasFromContainer(itemStack);
            if (gasStack == null) {
                super.func_70299_a(index, ItemStack.field_190927_a);
                return;
            }
            gas = gasStack.getGas();
            if (gas == null) {
                super.func_70299_a(index, ItemStack.field_190927_a);
                return;
            }
        }
        ItemStack stack = new ItemStack(ItemEnum.GASITEM.getItem());
        ItemGas.setGasName(stack, gas.getName());
        super.func_70299_a(index, stack);
    }
}

