/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import extracells.item.storage.ItemStorageCellPhysical;
import extracells.util.PlayerSource;
import extracells.util.StorageChannels;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum EnumBlockContainerMode {
    PLACE{

        @Override
        public void useMode(ItemStorageCellPhysical storagePhysical, ItemStack itemStack, IAEItemStack storageStack, IAEItemStack request, World world, BlockPos pos, EntityPlayer player, EnumFacing side, EnumHand hand, float hitX, float hitY, float hitZ) {
            super.useMode(storagePhysical, itemStack, storageStack, request, world, pos, player, side, hand, hitX, hitY, hitZ);
            request.setStackSize(1L);
            ItemBlock itemblock = (ItemBlock)itemStack.func_77973_b();
            itemblock.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
            itemblock.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
            storagePhysical.extractAEPower(player.func_184586_b(hand), 20.0, Actionable.MODULATE);
        }
    }
    ,
    TRADE{

        @Override
        public void useMode(ItemStorageCellPhysical storagePhysical, ItemStack itemStack, IAEItemStack storageStack, IAEItemStack request, World world, BlockPos pos, EntityPlayer player, EnumFacing side, EnumHand hand, float hitX, float hitY, float hitZ) {
            super.useMode(storagePhysical, itemStack, storageStack, request, world, pos, player, side, hand, hitX, hitY, hitZ);
            request.setStackSize(1L);
            world.func_175655_b(pos, true);
            this.placeBlock(storagePhysical, request.createItemStack(), world, player, pos, side, hand, hitX, hitY, hitZ);
        }
    }
    ,
    TRADE_BIG{

        @Override
        public void useMode(ItemStorageCellPhysical storagePhysical, ItemStack itemStack, IAEItemStack storageStack, IAEItemStack request, World world, BlockPos pos, EntityPlayer player, EnumFacing side, EnumHand hand, float hitX, float hitY, float hitZ) {
            super.useMode(storagePhysical, itemStack, storageStack, request, world, pos, player, side, hand, hitX, hitY, hitZ);
            request.setStackSize(9L);
            if (storageStack.getStackSize() > 9L && storagePhysical.getAECurrentPower(itemStack) >= 180.0) {
                switch (side) {
                    case NORTH: 
                    case SOUTH: {
                        this.placeBlocks(storagePhysical, request.createItemStack(), world, player, pos, side, hand, hitX, hitY, hitZ, new BlockPos(-1, -1, 0), new BlockPos(1, 1, 0));
                        break;
                    }
                    case DOWN: 
                    case UP: {
                        this.placeBlocks(storagePhysical, request.createItemStack(), world, player, pos, side, hand, hitX, hitY, hitZ, new BlockPos(-1, 0, -1), new BlockPos(1, 0, 1));
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        this.placeBlocks(storagePhysical, request.createItemStack(), world, player, pos, side, hand, hitX, hitY, hitZ, new BlockPos(0, -1, -1), new BlockPos(0, 1, 1));
                    }
                }
            }
        }
    };


    public static EnumBlockContainerMode get(int modeIndex) {
        if (EnumBlockContainerMode.values().length <= modeIndex) {
            return EnumBlockContainerMode.values()[0];
        }
        return EnumBlockContainerMode.values()[modeIndex];
    }

    public void useMode(ItemStorageCellPhysical storagePhysical, ItemStack itemStack, IAEItemStack storageStack, IAEItemStack request, World world, BlockPos pos, EntityPlayer player, EnumFacing side, EnumHand hand, float hitX, float hitY, float hitZ) {
        ICellInventoryHandler cellInventory = AEApi.instance().registries().cell().getCellInventory(itemStack, null, (IStorageChannel)StorageChannels.ITEM());
        cellInventory.extractItems((IAEStack)request, Actionable.MODULATE, (IActionSource)new PlayerSource(player, null));
    }

    public void placeBlocks(ItemStorageCellPhysical storagePhysical, ItemStack itemstack, World world, EntityPlayer player, BlockPos pos, EnumFacing side, EnumHand hand, float hitX, float hitY, float hitZ, BlockPos minOffset, BlockPos maxOffset) {
        for (int xOffset = minOffset.func_177958_n(); xOffset <= maxOffset.func_177958_n(); ++xOffset) {
            for (int yOffset = minOffset.func_177956_o(); yOffset <= maxOffset.func_177956_o(); ++yOffset) {
                for (int zOffset = minOffset.func_177952_p(); zOffset <= maxOffset.func_177952_p(); ++zOffset) {
                    BlockPos position = pos.func_177982_a(xOffset, yOffset, zOffset);
                    IBlockState blockState = world.func_180495_p(position);
                    if (blockState.func_177230_c() == Blocks.field_150357_h || !(blockState.func_185887_b(world, pos) >= 0.0f)) continue;
                    world.func_175655_b(position, true);
                    this.placeBlock(storagePhysical, itemstack, world, player, position, side, hand, hitX, hitY, hitZ);
                }
            }
        }
    }

    public void placeBlock(ItemStorageCellPhysical storagePhysical, ItemStack itemstack, World world, EntityPlayer player, BlockPos pos, EnumFacing side, EnumHand hand, float xOffset, float yOffset, float zOffset) {
        storagePhysical.extractAEPower(player.func_184586_b(hand), 20.0, Actionable.MODULATE);
        ItemBlock itemblock = (ItemBlock)itemstack.func_77973_b();
        BlockPos position = pos.func_177972_a(side.func_176734_d());
        itemblock.onItemUseFirst(player, world, position, side, xOffset, yOffset, zOffset, hand);
        itemblock.func_180614_a(player, world, position, hand, side, xOffset, yOffset, zOffset);
    }
}

