/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.misc;

import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.ITexturedBlock;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockUtility
extends Block
implements ITexturedBlock,
IBootable,
ILocaleBlock {
    public static PropertyInteger metadata = PropertyInteger.func_177719_a((String)"metadata", (int)0, (int)6);

    public BlockUtility() {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(1)));
        this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(2)));
        this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(3)));
        this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(4)));
        this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(5)));
        this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(6)));
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    @Override
    public LocaleComp getName() {
        return Ic2BlockLang.utilityBlock;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{metadata});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)metadata);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(meta));
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(IBlockState state) {
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)metadata);
        return meta == 2 || meta == 1 || meta == 4 || meta == 6;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int meta = (Integer)state.func_177229_b((IProperty)metadata);
        return meta == 3 || meta == 5;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        switch ((Integer)blockState.func_177229_b((IProperty)metadata)) {
            case 0: {
                return 6.0f;
            }
            case 1: {
                return 6.0f;
            }
            case 2: {
                return 80.0f;
            }
            case 3: {
                return 15.0f;
            }
            case 4: {
                return 80.0f;
            }
            case 5: {
                return 15.0f;
            }
            case 6: {
                return 80.0f;
            }
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        switch ((Integer)state.func_177229_b((IProperty)metadata)) {
            case 0: {
                return 10.0f;
            }
            case 1: {
                return 10.0f;
            }
            case 2: {
                return 150.0f;
            }
            case 3: {
                return 150.0f;
            }
            case 4: {
                return 150.0f;
            }
            case 5: {
                return 150.0f;
            }
            case 6: {
                return 150.0f;
            }
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public Material func_149688_o(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)metadata);
        return meta == 3 || meta == 5 ? Material.field_151592_s : Material.field_151573_f;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        int meta = (Integer)state.func_177229_b((IProperty)metadata);
        if (meta == 3 || meta == 5) {
            return layer == BlockRenderLayer.CUTOUT;
        }
        return super.canRenderInLayer(state, layer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureFromState(IBlockState state, EnumFacing par1) {
        switch ((Integer)state.func_177229_b((IProperty)metadata)) {
            case 0: {
                return Ic2Icons.getTextures("b0")[35];
            }
            case 1: {
                return Ic2Icons.getTextures("b0")[36];
            }
            case 2: {
                return Ic2Icons.getTextures("b0")[12];
            }
            case 3: {
                return Ic2Icons.getTextures("b0")[13];
            }
            case 4: {
                return Ic2Icons.getTextures("b0")[9];
            }
            case 5: {
                return Ic2Icons.getTextures("b0")[11];
            }
            case 6: {
                return Ic2Icons.getTextures("b0")[10];
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        switch ((Integer)state.func_177229_b((IProperty)metadata)) {
            case 0: {
                return Ic2Icons.getTextures("b0")[35];
            }
            case 1: {
                return Ic2Icons.getTextures("b0")[36];
            }
            case 2: {
                return Ic2Icons.getTextures("b0")[12];
            }
            case 3: {
                return Ic2Icons.getTextures("b0")[13];
            }
            case 4: {
                return Ic2Icons.getTextures("b0")[9];
            }
            case 5: {
                return Ic2Icons.getTextures("b0")[11];
            }
            case 6: {
                return Ic2Icons.getTextures("b0")[10];
            }
        }
        return null;
    }

    @Override
    public List<IBlockState> getValidStates() {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        IBlockState state = this.func_176223_P();
        for (int i = 0; i < 7; ++i) {
            states.add(state.func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(i)));
        }
        return states;
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176203_a(stack.func_77960_j());
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 1; i < 7; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public void onLoad() {
        Ic2Items.miningPipeTip = new ItemStack((Block)this, 1, 1);
        Ic2Items.reinforcedStone = new ItemStack((Block)this, 1, 2);
        Ic2Items.reinforcedGlass = new ItemStack((Block)this, 1, 3);
        Ic2Items.reinforcedStoneBrick = new ItemStack((Block)this, 1, 4);
        Ic2Items.reinforcedGlassClear = new ItemStack((Block)this, 1, 5);
        Ic2Items.reinforcedStoneCrackt = new ItemStack((Block)this, 1, 6);
        Ic2States.miningPipeTip = this.func_176203_a(1);
        Ic2States.reinforcedStone = this.func_176203_a(2);
        Ic2States.reinforcedGlass = this.func_176203_a(3);
        Ic2States.reinforcedStoneBrick = this.func_176203_a(4);
        Ic2States.reinforcedGlassClear = this.func_176203_a(5);
        Ic2States.reinforcedStoneCrackt = this.func_176203_a(6);
    }

    public int func_149717_k(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)metadata);
        return meta == 3 || meta == 0 || meta == 5 ? 0 : 255;
    }

    public int func_180651_a(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)metadata);
        return meta == 1 ? 0 : meta;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = (Integer)state.func_177229_b((IProperty)metadata);
        if (meta == 0 || meta == 1) {
            return Ic2Items.miningPipe.func_77973_b();
        }
        return meta == 3 || meta == 5 ? null : super.func_180660_a(state, rand, fortune);
    }

    public boolean func_149686_d(IBlockState state) {
        int meta = this.func_176201_c(state);
        return meta == 2 || meta == 4 || meta == 6;
    }

    public boolean func_149730_j(IBlockState state) {
        int meta = this.func_176201_c(state);
        return meta >= 2 && meta <= 6;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.func_176201_c(state) == 1) {
            return Ic2Items.miningPipe;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        int meta = this.func_176201_c(blockState);
        if (meta == 3 || meta == 5) {
            IBlockState other = blockAccess.func_180495_p(pos.func_177972_a(side));
            if (other.func_177230_c() != this) {
                return true;
            }
            int otherMeta = this.func_176201_c(other);
            return otherMeta != 3 && otherMeta != 5;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }
}

