/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.resources;

import ic2.core.IC2;
import ic2.core.block.resources.BlockRubberWood;
import ic2.core.platform.registry.Ic2States;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;

public class WorldGenRubberTree
extends WorldGenerator {
    boolean notify;
    int count;

    public WorldGenRubberTree() {
        super(true);
        this.notify = true;
    }

    public WorldGenRubberTree(int par2) {
        super(false);
        this.notify = false;
        this.count = par2;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (this.notify) {
            return this.grow(worldIn, rand, position);
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(position);
        while (this.count > 0) {
            while (this.canGoThrougBlock(worldIn, (BlockPos)pos)) {
                pos.func_189536_c(EnumFacing.DOWN);
            }
            if (!this.grow(worldIn, rand, pos.func_177984_a())) {
                this.count -= 3;
            }
            pos = new BlockPos.MutableBlockPos(position.func_177958_n() + (rand.nextInt(15) - 7), position.func_177956_o(), pos.func_177952_p() + (rand.nextInt(15) - 7));
            --this.count;
        }
        return true;
    }

    private boolean canGoThrougBlock(World world, BlockPos pos) {
        if (pos.func_177956_o() <= 0) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            return true;
        }
        Material mat = state.func_185904_a();
        if (mat.func_76224_d()) {
            return false;
        }
        return block.func_176200_f((IBlockAccess)world, pos);
    }

    private boolean grow(World worldIn, Random rand, BlockPos pos) {
        int i;
        if (worldIn == null) {
            IC2.log.error("Had a null that shouldn't have been. RubberTree did not spawn! w=" + worldIn);
            return false;
        }
        int treeholechance = 25;
        int h = this.getGrowHeight(worldIn, pos);
        if (h < 2) {
            return false;
        }
        int height = h / 2;
        h -= h / 2;
        height += rand.nextInt(h + 1);
        Block log = Ic2States.rubberWood.func_177230_c();
        Block leaves = Ic2States.rubberLeaves.func_177230_c();
        for (i = 0; i < height; ++i) {
            BlockPos newPos = pos.func_177981_b(i);
            worldIn.func_175656_a(newPos, log.func_176223_P());
            if (rand.nextInt(100) <= treeholechance) {
                treeholechance -= 10;
                worldIn.func_175656_a(pos.func_177981_b(i), log.func_176223_P().func_177226_a((IProperty)BlockRubberWood.resin, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockRubberWood.collectable, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockRubberWood.resinFacing, (Comparable)EnumFacing.field_176754_o[rand.nextInt(4)]));
            }
            IC2.network.get().announceBlockUpdate(worldIn, newPos);
            if (height >= 4 && (height >= 7 || i <= 1) && i <= 2) continue;
            int x = newPos.func_177958_n();
            int z = newPos.func_177952_p();
            for (int a = x - 2; a <= x + 2; ++a) {
                for (int b = z - 2; b <= z + 2; ++b) {
                    boolean gen;
                    int c = i + 4 - height;
                    if (c < 1) {
                        c = 1;
                    }
                    boolean bl = gen = a > x - 2 && a < x + 2 && b > z - 2 && b < z + 2 || a > x - 2 && a < x + 2 && rand.nextInt(c) == 0 || b > z - 2 && b < z + 2 && rand.nextInt(c) == 0;
                    if (!gen || !worldIn.func_175623_d(new BlockPos(a, newPos.func_177956_o(), b))) continue;
                    worldIn.func_175656_a(new BlockPos(a, newPos.func_177956_o(), b), leaves.func_176223_P());
                }
            }
        }
        for (i = 0; i <= height / 4 + rand.nextInt(2); ++i) {
            if (!worldIn.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + height + i, pos.func_177952_p()))) continue;
            worldIn.func_175656_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + height + i, pos.func_177952_p()), leaves.func_176223_P());
        }
        return true;
    }

    private int getGrowHeight(World world, BlockPos actualPos) {
        IBlockState belowState = world.func_180495_p(actualPos.func_177977_b());
        Block below = belowState.func_177230_c();
        if (!below.canSustainPlant(belowState, (IBlockAccess)world, actualPos.func_177977_b(), EnumFacing.UP, (IPlantable)Ic2States.rubberSapling.func_177230_c()) || !world.func_175623_d(actualPos) && world.func_180495_p(actualPos).func_177230_c() != Ic2States.rubberSapling.func_177230_c()) {
            return 0;
        }
        BlockPos pos = actualPos.func_177984_a();
        while (world.func_175623_d(pos) && pos.func_177956_o() - actualPos.func_177956_o() < 8) {
            pos = pos.func_177984_a();
        }
        return pos.func_177956_o() - actualPos.func_177956_o();
    }
}

