/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.core.block.wiring.tile.TileEntityCreativeEnergyStorage;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.ToolTipButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CreativeEnergyStorageComp
extends GuiComponent {
    TileEntityCreativeEnergyStorage energy;

    public CreativeEnergyStorageComp(TileEntityCreativeEnergyStorage tile) {
        super(Ic2GuiComp.nullBox);
        this.energy = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.FrontgroundDraw);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        gui.drawString(Ic2GuiLang.energyPerPacket.getLocalizedFormatted(this.energy.offer), 25, 20, 0x404040);
        gui.drawString(Ic2GuiLang.packetsPerTick.getLocalizedFormatted(this.energy.packets), 25, 35, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        LocaleComp alt = Ic2GuiLang.getAltKey("10");
        LocaleComp shift = Ic2GuiLang.getShiftKey("100");
        LocaleComp ctrl = Ic2GuiLang.getCtrlKey("1000");
        List<LocaleComp> all = Arrays.asList(alt, shift, ctrl);
        gui.registerButton(new ToolTipButton(0, x + 150, y + 35, 15, 12, "+").addText(alt));
        gui.registerButton(new ToolTipButton(1, x + 150, y + 18, 15, 12, "+").addComponents(all));
        gui.registerButton(new ToolTipButton(2, x + 5, y + 35, 15, 12, "-").addText(alt));
        gui.registerButton(new ToolTipButton(3, x + 5, y + 18, 15, 12, "-").addComponents(all));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int event;
        int id = button.field_146127_k;
        int value = id > 1 ? -1 : 1;
        int n = event = id == 0 || id == 2 ? 0 : 1;
        if (event == 0) {
            if (gui.func_175283_s()) {
                value *= 10;
            }
        } else {
            if (gui.func_146271_m()) {
                value *= 1000;
            }
            if (gui.func_146272_n()) {
                value *= 100;
            }
            if (gui.func_175283_s()) {
                value *= 10;
            }
        }
        this.energy.getNetwork().initiateClientTileEntityEvent(this.energy, event, value);
    }
}

