/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.management;

import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.management.IModularSlot;
import ic2.core.inventory.management.InventoryHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ModularInventoryHandler
implements IItemHandler {
    EnumFacing side;
    InventoryHandler handler;
    IModularSlot modular;

    public ModularInventoryHandler(InventoryHandler inv, EnumFacing realSide, IModularSlot slot) {
        this.handler = inv;
        this.side = realSide;
        this.modular = slot;
    }

    public int getSlots() {
        return this.modular.getSlotCount();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.handler.getInventory().getStackInSlot(this.modular.getRealSlot(slot));
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int realSlot = this.modular.getRealSlot(slot);
        if (!this.handler.getAccess(realSlot, this.side).canImport()) {
            return stack;
        }
        IFilter filter = this.handler.getInputFilter(realSlot);
        if (filter != null && !filter.matches(stack)) {
            return stack;
        }
        IHasInventory inv = this.handler.getInventory();
        ItemStack invStack = inv.getStackInSlot(realSlot);
        if (invStack.func_190926_b()) {
            int max = Math.min(stack.func_77976_d(), inv.getMaxStackSize(realSlot));
            if (stack.func_190916_E() < max) {
                ItemStack copy = stack.func_77946_l();
                if (!simulate) {
                    inv.setStackInSlot(realSlot, copy.func_77979_a(max));
                    return copy;
                }
                copy.func_190918_g(max);
                return copy;
            }
            if (!simulate) {
                inv.setStackInSlot(realSlot, stack);
            }
            return ItemStack.field_190927_a;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack)) {
            return stack;
        }
        int toAdd = Math.min(stack.func_77976_d() - invStack.func_190916_E(), inv.getMaxStackSize(realSlot));
        if (toAdd <= 0) {
            return stack;
        }
        if (toAdd > stack.func_190916_E()) {
            if (!simulate) {
                ItemStack copy = invStack.func_77946_l();
                copy.func_190917_f(stack.func_190916_E());
                inv.setStackInSlot(realSlot, copy);
            }
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        if (simulate) {
            copy.func_190918_g(toAdd);
            return copy;
        }
        copy.func_190918_g(toAdd);
        ItemStack realCopy = invStack.func_77946_l();
        realCopy.func_190917_f(toAdd);
        inv.setStackInSlot(realSlot, realCopy);
        return copy;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack split;
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        int realSlot = this.modular.getRealSlot(slot);
        if (!this.handler.getAccess(realSlot, this.side).canExport()) {
            return ItemStack.field_190927_a;
        }
        IHasInventory inv = this.handler.getInventory();
        ItemStack stack = inv.getStackInSlot(realSlot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IFilter exportFilter = this.handler.getOutputFilter(realSlot);
        if (exportFilter != null && !exportFilter.matches(stack)) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            split = stack.func_77946_l();
            split.func_190920_e(Math.min(stack.func_190916_E(), amount));
        } else {
            split = stack.func_77979_a(amount);
        }
        return split;
    }

    public int getSlotLimit(int slot) {
        return this.handler.getInventory().getMaxStackSize(this.modular.getRealSlot(slot));
    }
}

