/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.inventory;

import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.inventory.management.IInventoryModifier;
import ic2.core.item.upgrades.subtypes.inventory.BaseMetaInventoryUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.math.MathUtil;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AutomationUpgrade
extends BaseMetaInventoryUpgrade {
    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list, boolean adv, Map<ToolTipType, List<String>> sortedToolTips) {
        sortedToolTips.get((Object)ToolTipType.Shift).add((this.isInverted(stack) ? Ic2InfoLang.invUpgradeRemoveAllSlots : Ic2InfoLang.invUpgradeAddSlotsToAll).getLocalized());
        List<String> ctrlTip = sortedToolTips.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2InfoLang.automationInvert.getLocalized());
    }

    @Override
    public void onInstalling(ItemStack stack, IHasHandler.IInventoryHandler handler) {
        if (this.isInverted(stack)) {
            handler.clearSide(RotationList.ALL);
            return;
        }
        handler.addSlotsForSide(RotationList.ALL, MathUtil.fromIntegerToInt(handler.getAllSlots()));
    }

    @Override
    public IInventoryModifier.EffectType getEffect() {
        return IInventoryModifier.EffectType.Slot;
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public ActionResult<ItemStack> onRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return super.onRightClick(stack, world, player, hand);
        }
        this.invert(stack);
        IC2.platform.messagePlayer(player, Ic2InfoLang.invUpgradeInvertedSettings);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return Ic2Icons.getTextures("i1")[160];
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.automationUpgrade;
    }

    private void invert(ItemStack stack) {
        NBTTagCompound nbt;
        nbt.func_74757_a("IsInverted", !(nbt = StackUtil.getOrCreateNbtData(stack)).func_74767_n("IsInverted"));
    }

    private boolean isInverted(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("IsInverted");
    }
}

