/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.textures.models;

import com.google.common.collect.ImmutableMap;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.IColorEffectedTexture;
import ic2.core.platform.textures.obj.ILayeredItemModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class LayeredItemModel
extends BaseModel {
    LayeredItemModel other;
    ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> map;
    List<BakedQuad> quads = new ArrayList<BakedQuad>();
    ItemStack stack;
    ILayeredItemModel layer;
    boolean gui;
    TextureAtlasSprite particle;

    public LayeredItemModel(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ItemStack stack, ILayeredItemModel model, TextureAtlasSprite particle) {
        super(transforms);
        this.stack = stack;
        this.layer = model;
        this.map = transforms;
        this.particle = particle;
    }

    @Override
    public void init() {
        this.gui = false;
        this.other = new LayeredItemModel(this.map, this.stack, this.layer, this.particle);
        this.other.gui = true;
        this.other.other = this;
        boolean color = this.layer instanceof IColorEffectedTexture;
        int layers = this.layer.getLayers(this.stack);
        for (int i = 0; i < layers; ++i) {
            TextureAtlasSprite sprite = this.layer.getTexture(i, this.stack);
            if (sprite == null) continue;
            this.quads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)(color ? i : -1), (TextureAtlasSprite)sprite, (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(this.getCamera().get((Object)ItemCameraTransforms.TransformType.GUI))));
            for (BakedQuad quad : this.quads) {
                if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
                this.other.quads.add(quad);
            }
        }
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side == null) {
            return this.quads;
        }
        return this.getEmptyList();
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        Pair pair = PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getCamera(), (ItemCameraTransforms.TransformType)type);
        if (type == ItemCameraTransforms.TransformType.GUI && !this.gui) {
            return Pair.of((Object)((Object)this.other), null);
        }
        if (type != ItemCameraTransforms.TransformType.GUI && this.gui) {
            return Pair.of((Object)((Object)this.other), (Object)pair.getRight());
        }
        return pair;
    }
}

