/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.profiler;

import cf.terminator.laggoggles.client.gui.GuiScanResultsWorld;
import cf.terminator.laggoggles.packet.ObjectData;
import cf.terminator.laggoggles.packet.SPacketScanResult;
import cf.terminator.laggoggles.profiler.ScanType;
import cf.terminator.laggoggles.util.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ProfileResult {
    public static final ProfileResult EMPTY_RESULT = new ProfileResult(0L, 0L, 0L, Side.UNKNOWN, ScanType.EMPTY);
    private final long startTime;
    private long endTime;
    private long totalTime;
    private long tickCount;
    private boolean isLocked = false;
    private Side side;
    private ScanType type;
    private long totalFrames = 0L;
    private List<ObjectData> cachedList = null;
    private final ArrayList<ObjectData> OBJECT_DATA = new ArrayList();
    private List<GuiScanResultsWorld.LagSource> lagSources = null;

    public ProfileResult(long startTime, long endTime, long tickCount, Side side, ScanType type) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.totalTime = endTime - startTime;
        this.tickCount = tickCount;
        this.side = side;
        this.type = type;
    }

    private ProfileResult(ProfileResult original, boolean copyData) {
        this.startTime = original.startTime;
        this.endTime = original.endTime;
        this.totalTime = original.totalTime;
        this.tickCount = original.tickCount;
        this.totalFrames = original.totalFrames;
        this.type = original.type;
        this.side = original.side;
        if (copyData) {
            this.OBJECT_DATA.addAll(original.OBJECT_DATA);
        }
    }

    public void setFrames(long frames) {
        if (this.isLocked) {
            throw new IllegalStateException("This data is for review only. You can't modify it. use copy() instead.");
        }
        this.totalFrames = frames;
    }

    public void addData(ObjectData data) {
        if (this.isLocked) {
            throw new IllegalStateException("This data is for review only. You can't modify it. use copy() instead.");
        }
        this.OBJECT_DATA.add(data);
    }

    public boolean removeData(ObjectData data) {
        if (this.isLocked) {
            throw new IllegalStateException("This data is for review only. You can't modify it. use copy() instead.");
        }
        return this.OBJECT_DATA.remove(data);
    }

    public boolean addAll(Collection<? extends ObjectData> data) {
        if (this.isLocked) {
            throw new IllegalStateException("This data is for review only. You can't modify it. use copy() instead.");
        }
        return this.OBJECT_DATA.addAll(data);
    }

    public List<ObjectData> getData() {
        if (this.cachedList == null) {
            this.cachedList = Collections.unmodifiableList(this.OBJECT_DATA);
        }
        return this.cachedList;
    }

    public List<GuiScanResultsWorld.LagSource> getLagSources() {
        if (this.lagSources == null) {
            ArrayList<GuiScanResultsWorld.LagSource> tmp = new ArrayList<GuiScanResultsWorld.LagSource>();
            for (ObjectData entity : this.getData()) {
                tmp.add(new GuiScanResultsWorld.LagSource((Long)entity.getValue(ObjectData.Entry.NANOS), entity));
            }
            Collections.sort(tmp);
            this.lagSources = Collections.unmodifiableList(tmp);
        }
        return this.lagSources;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getTickCount() {
        return this.tickCount;
    }

    public Side getSide() {
        return this.side;
    }

    public ScanType getType() {
        return this.type;
    }

    public long getTotalFrames() {
        return this.totalFrames;
    }

    public ProfileResult copy() {
        return new ProfileResult(this, true);
    }

    public ProfileResult copyStatsOnly() {
        return new ProfileResult(this, false);
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public double getTPS() {
        double seconds = (double)this.totalTime / 1.0E9;
        return (double)this.tickCount / seconds;
    }

    public double getFPS() {
        double seconds = (double)this.totalTime / 1.0E9;
        return (double)this.totalFrames / seconds;
    }

    public double getNanoPerFrame() {
        return (double)this.totalTime / (double)this.totalFrames;
    }

    public void lock() {
        this.isLocked = true;
    }

    private SPacketScanResult getPacket() {
        SPacketScanResult result = new SPacketScanResult();
        result.endTime = this.endTime;
        result.startTime = this.startTime;
        result.tickCount = this.tickCount;
        result.totalTime = this.totalTime;
        result.side = this.side;
        result.type = this.type;
        result.totalFrames = this.totalFrames;
        result.DATA.addAll(this.OBJECT_DATA);
        return result;
    }

    public List<SPacketScanResult> createPackets() {
        ArrayList<SPacketScanResult> list = new ArrayList<SPacketScanResult>();
        ArrayList<ObjectData> data = new ArrayList<ObjectData>(this.OBJECT_DATA);
        while (data.size() > 0) {
            SPacketScanResult packet = new SPacketScanResult();
            packet.endTime = this.endTime;
            packet.startTime = this.startTime;
            packet.tickCount = this.tickCount;
            packet.totalTime = this.totalTime;
            packet.side = this.side;
            packet.type = this.type;
            packet.totalFrames = this.totalFrames;
            packet.hasMore = true;
            ArrayList<ObjectData> sub = new ArrayList<ObjectData>(data.subList(0, Math.min(10, data.size())));
            data.removeAll(sub);
            packet.DATA.addAll(sub);
            list.add(packet);
        }
        ((SPacketScanResult)list.get((int)(list.size() - 1))).hasMore = false;
        return list;
    }
}

