/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server;

import java.util.Map;
import journeymap.common.CommonProxy;
import journeymap.common.Journeymap;
import journeymap.common.network.PacketHandler;
import journeymap.common.version.Version;
import journeymap.server.events.ForgeEvents;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

public class JourneymapServer
implements CommonProxy {
    private Logger logger = Journeymap.getLogger();
    public static boolean DEV_MODE = false;
    private static final Version MINIMUM_ACCEPTABLE_VERSION = new Version(5, 5, 2);

    @Override
    @SideOnly(value=Side.SERVER)
    @Mod.EventHandler
    public void preInitialize(FMLPreInitializationEvent event) {
    }

    @Override
    public void initialize(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEvents());
        PacketHandler.init(Side.SERVER);
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public void postInitialize(FMLPostInitializationEvent event) {
    }

    @Override
    public boolean checkModLists(Map<String, String> modList, Side side) {
        this.logger.info(side.toString());
        for (String s : modList.keySet()) {
            if (!s.toLowerCase().equals("journeymap") && !s.toLowerCase().equals("journeymap@")) continue;
            if (modList.get(s).contains("@")) {
                this.logger.info("Mod check = dev environment");
                DEV_MODE = true;
                return true;
            }
            String version = modList.get(s).split("-")[1];
            Version userLoggedInVersion = Version.from(version, null);
            if (MINIMUM_ACCEPTABLE_VERSION.isNewerThan(userLoggedInVersion)) {
                this.logger.info("Version Mismatch need " + MINIMUM_ACCEPTABLE_VERSION.toString() + " or higher. Current version attempt -> " + modList.get(s));
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean isUpdateCheckEnabled() {
        return false;
    }

    @Override
    public void handleWorldIdMessage(String message, EntityPlayerMP playerEntity) {
        if (PropertiesManager.getInstance().getGlobalProperties().useWorldId.get().booleanValue()) {
            PacketHandler.sendPlayerWorldID(playerEntity);
        }
    }
}

