/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.core.registers.items.GSItems;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockAdvCircuitFabricator;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.recipe.CircuitFabricatorRecipes;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityAdvCircuitFabricator
extends TileBaseElectricBlockWithInventory
implements ISidedInventory {
    public static final int PROCESS_TIME_REQUIRED = 300;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack producingStack = ItemStack.field_190927_a;
    private long ticks;

    public TileEntityAdvCircuitFabricator() {
        super("tile.adv_circuit_fabricator.name");
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 40.0f : 20.0f);
        this.inventory = NonNullList.func_191197_a((int)11, (Object)ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        super.func_73660_a();
        this.updateInput();
        if (!this.field_145850_b.field_72995_K) {
            boolean updateInv = false;
            if (this.hasEnoughEnergyToRun) {
                if (this.canCompress()) {
                    int boost_speed = 0;
                    int energy_boost = 0;
                    for (int i = 0; i <= 3; ++i) {
                        if (((ItemStack)this.getInventory().get(this.getInventory().size() - i - 1)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 2))) {
                            ++boost_speed;
                        }
                        if (!((ItemStack)this.getInventory().get(this.getInventory().size() - i - 1)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 3))) continue;
                        ++energy_boost;
                    }
                    this.processTicks += 2 + boost_speed;
                    this.storage.setMaxExtract(ConfigManagerCore.hardMode ? (float)(90 + 40 * boost_speed - 20 * energy_boost) : (float)(75 + 35 * boost_speed - 15 * energy_boost));
                    if (this.processTicks >= this.getProcessTimeRequired()) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.3f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        this.processTicks = 0;
                        this.compressItems();
                        updateInv = true;
                    }
                } else {
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
        ++this.ticks;
    }

    public int getProcessTimeRequired() {
        return 600 / (1 + this.poweredByTierGC);
    }

    public void updateInput() {
        this.producingStack = CircuitFabricatorRecipes.getOutputForInput((List)this.getInventory().subList(1, 6));
    }

    private boolean canCompress() {
        if (this.producingStack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.getInventory().get(6)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.getInventory().get(6)).func_190926_b() && !((ItemStack)this.getInventory().get(6)).func_77969_a(this.producingStack)) {
            return false;
        }
        int result = ((ItemStack)this.getInventory().get(6)).func_190926_b() ? 0 : ((ItemStack)this.getInventory().get(6)).func_190916_E() + this.producingStack.func_190916_E();
        return result <= this.func_70297_j_() && result <= this.producingStack.func_77976_d();
    }

    public void compressItems() {
        if (this.canCompress()) {
            ItemStack resultItemStack = this.producingStack.func_77946_l();
            if (this.field_145850_b.field_73011_w instanceof IZeroGDimension && resultItemStack.func_77973_b() == GCItems.basicItem) {
                if (resultItemStack.func_77952_i() == 13) {
                    resultItemStack.func_190920_e(5);
                } else if (resultItemStack.func_77952_i() == 12) {
                    resultItemStack.func_190920_e(15);
                } else {
                    resultItemStack.func_190920_e(resultItemStack.func_190916_E() * 2);
                }
            }
            if (((ItemStack)this.getInventory().get(6)).func_190926_b()) {
                this.getInventory().set(6, (Object)resultItemStack);
            } else if (((ItemStack)this.getInventory().get(6)).func_77969_a(resultItemStack)) {
                if (((ItemStack)this.getInventory().get(6)).func_190916_E() + resultItemStack.func_190916_E() > 64) {
                    resultItemStack.func_190920_e(((ItemStack)this.getInventory().get(6)).func_190916_E() + resultItemStack.func_190916_E() - 64);
                    GCCoreUtil.spawnItem((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (ItemStack)resultItemStack);
                    ((ItemStack)this.getInventory().get(6)).func_190920_e(64);
                } else {
                    ((ItemStack)this.getInventory().get(6)).func_190917_f(resultItemStack.func_190916_E());
                }
            }
        }
        for (int i = 1; i < 6; ++i) {
            this.func_70298_a(i, 1);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        return nbt;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return itemStack != null && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
        }
        if (slotID > 5) {
            return false;
        }
        ArrayList list = (ArrayList)CircuitFabricatorRecipes.slotValidItems.get(slotID - 1);
        for (ItemStack test : list) {
            if (!test.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        boolean siliconFlag;
        if (side == EnumFacing.DOWN) {
            return new int[]{6};
        }
        boolean bl = siliconFlag = !((ItemStack)this.getInventory().get(2)).func_190926_b() && (((ItemStack)this.getInventory().get(3)).func_190926_b() || ((ItemStack)this.getInventory().get(3)).func_190916_E() < ((ItemStack)this.getInventory().get(2)).func_190916_E());
        if (siliconFlag) {
            int[] nArray2 = new int[5];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArray = nArray2;
            nArray2[4] = 5;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 4;
            nArray = nArray3;
            nArray3[4] = 5;
        }
        return nArray;
    }

    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID < 6 && this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID == 6;
    }

    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockAdvCircuitFabricator) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockAdvCircuitFabricator.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }
}

