/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class BakedSimpleItem
implements IBakedModel {
    private final ImmutableList<BakedQuad> quads;
    private final TextureAtlasSprite particle;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private final IBakedModel otherModel;
    private final boolean isCulled;
    private final ItemOverrideList overrides;

    public BakedSimpleItem(ImmutableList<BakedQuad> quads, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, IBakedModel original) {
        this(quads, original.func_177554_e(), transforms, original.func_188617_f(), null);
    }

    private BakedSimpleItem(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ItemOverrideList overrides, @Nullable IBakedModel unculledModel) {
        this.quads = quads;
        this.particle = particle;
        this.transforms = transforms;
        this.overrides = overrides;
        if (unculledModel != null) {
            this.otherModel = unculledModel;
            this.isCulled = true;
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (BakedQuad quad : quads) {
                if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
                builder.add((Object)quad);
            }
            this.otherModel = new BakedSimpleItem((ImmutableList<BakedQuad>)builder.build(), particle, transforms, overrides, this);
            this.isCulled = false;
        }
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null) {
            return this.quads;
        }
        return ImmutableList.of();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        Pair pair = PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        if (type == ItemCameraTransforms.TransformType.GUI && !this.isCulled && pair.getRight() == null) {
            return Pair.of((Object)this.otherModel, null);
        }
        if (type != ItemCameraTransforms.TransformType.GUI && this.isCulled) {
            return Pair.of((Object)this.otherModel, (Object)pair.getRight());
        }
        return pair;
    }
}

