/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.tools;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.ItemElectricTool;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.gravisuit.util.Config;
import trinsdar.gravisuit.util.GravisuitLang;

public class ItemToolAdvancedChainsaw
extends ItemElectricTool
implements IStaticTexturedItem {
    public static final ItemStack ironAxe = new ItemStack(Items.field_151036_c);

    public ItemToolAdvancedChainsaw() {
        super(0.0f, 0.0f, Item.ToolMaterial.IRON);
        this.field_77865_bY = 4.0f;
        this.maxCharge = Config.advancedChainsawStorage;
        this.transferLimit = Config.advancedChainsawTransfer;
        this.operationEnergyCost = 100;
        this.tier = 2;
        this.field_77864_a = 15.0f;
        this.setHarvestLevel("axe", 2);
        this.setRegistryName("advancedchainsaw");
        this.setUnlocalizedName(GravisuitLang.advancedChainsaw);
        this.func_77637_a(IC2.tabIC2);
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setMaxCharge(int storage) {
        this.maxCharge = storage;
    }

    public void setMaxTransfer(int maxTransfer) {
        this.transferLimit = maxTransfer;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(GravisuitLang.advancedChainsaw1.getLocalized());
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int i) {
        return Ic2Icons.getTextures((String)"gravisuit_items")[8];
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return ironAxe.func_150998_b(state) || state.func_177230_c() == Blocks.field_150321_G;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        if (!ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack))) {
            return 1.0f;
        }
        return material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151584_j && material != Material.field_151570_A && material != Material.field_151572_C && material != Material.field_151580_n ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase entity, EnumHand hand) {
        return Ic2Items.chainSaw.func_77973_b().func_111207_a(stack, playerIn, entity, hand);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        World worldIn = player.field_70170_p;
        if (!player.func_70093_af()) {
            BlockPos nextPos;
            IBlockState nextState;
            for (int i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = pos.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                this.breakBlock(nextPos, itemstack, worldIn, pos, player);
            }
        }
        if (ElectricItem.manager.canUse(itemstack, (double)this.operationEnergyCost)) {
            IC2.audioManager.playOnce((Object)player, Ic2Sounds.chainsawUseOne);
        }
        return Ic2Items.chainSaw.func_77973_b().onBlockStartBreak(itemstack, pos, player);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            IC2.achievements.issueStat((EntityPlayer)entityLiving, "blocksSawed");
        }
        return super.func_179218_a(stack, worldIn, blockIn, pos, entityLiving);
    }

    public void breakBlock(BlockPos pos, ItemStack saw, World world, BlockPos oldPos, EntityPlayer player) {
        if (oldPos == pos) {
            return;
        }
        if (!ElectricItem.manager.canUse(saw, (double)this.getEnergyCost(saw))) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_185887_b(world, pos) == -1.0f) {
            return;
        }
        ElectricItem.manager.use(saw, (double)this.getEnergyCost(saw), (EntityLivingBase)player);
        blockState.func_177230_c().func_180657_a(world, player, pos, blockState, world.func_175625_s(pos), saw);
        world.func_175698_g(pos);
        world.func_175713_t(pos);
    }

    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.DIGGER;
    }

    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return ench instanceof EnchantmentDamage;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return Ic2Items.chainSaw.func_77973_b().func_77644_a(stack, target, attacker);
    }
}

