/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import net.smoofyuniverse.mirage.api.modifier.ChunkModifier;
import net.smoofyuniverse.mirage.api.modifier.ChunkModifierRegistryModule;
import net.smoofyuniverse.mirage.api.volume.ChunkView;
import net.smoofyuniverse.mirage.config.global.GlobalConfig;
import net.smoofyuniverse.mirage.config.serializer.BlockSetSerializer;
import net.smoofyuniverse.mirage.event.PlayerEventListener;
import net.smoofyuniverse.mirage.event.WorldEventListener;
import net.smoofyuniverse.mirage.impl.internal.InternalBlockState;
import net.smoofyuniverse.mirage.impl.internal.InternalServer;
import net.smoofyuniverse.mirage.impl.internal.InternalWorld;
import net.smoofyuniverse.mirage.impl.network.NetworkChunk;
import net.smoofyuniverse.mirage.ore.OreAPI;
import net.smoofyuniverse.mirage.resource.Resources;
import net.smoofyuniverse.mirage.util.IOUtil;
import net.smoofyuniverse.mirage.util.MathUtil;
import net.smoofyuniverse.mirage.util.collection.BlockSet;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.GuiceObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.bstats.sponge.MetricsLite2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Game;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameConstructionEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

@Plugin(id="mirage", name="Mirage", version="1.3.8", authors={"Yeregorix"}, description="The best solution against xray users")
public class Mirage {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mirage");
    private static Mirage instance;
    @Inject
    private Game game;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDir;
    @Inject
    private PluginContainer container;
    @Inject
    private GuiceObjectMapperFactory factory;
    @Inject
    private MetricsLite2 metrics;
    private ConfigurationOptions configOptions;
    private Task updateTask;
    private Path cacheDir;
    private Path worldConfigsDir;
    private Path resourcesDir;
    private GlobalConfig.Immutable globalConfig;
    private Text[] updateMessages = new Text[0];

    public Mirage() {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
    }

    @Listener
    public void onGameConstruction(GameConstructionEvent e) {
        this.game.getRegistry().registerModule(ChunkModifier.class, (CatalogRegistryModule)ChunkModifierRegistryModule.get());
        TypeSerializers.getDefaultSerializers().registerType(BlockSet.TOKEN, (TypeSerializer)new BlockSetSerializer(BlockSet.SerializationPredicate.limit(0.6f)));
    }

    @Listener
    public void onGamePreInit(GamePreInitializationEvent e) {
        this.cacheDir = this.game.getGameDirectory().resolve("mirage-cache");
        this.worldConfigsDir = this.configDir.resolve("worlds");
        this.resourcesDir = this.configDir.resolve("resources");
        try {
            Files.createDirectories(this.worldConfigsDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.createDirectories(this.resourcesDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.configOptions = ConfigurationOptions.defaults().setObjectMapperFactory((ObjectMapperFactory)this.factory);
    }

    @Listener
    public void onGameInit(GameInitializationEvent e) {
        LOGGER.info("Loading global configuration ..");
        try {
            this.loadGlobalConfig();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load global configuration", (Throwable)ex);
        }
        LOGGER.info("Optimizing exposition check performances ..");
        for (BlockState b : this.game.getRegistry().getAllOf(BlockState.class)) {
            try {
                ((InternalBlockState)b).optimizeExpositionCheck();
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to optimize block: " + b.getId(), (Throwable)ex);
            }
        }
        try {
            Resources.loadResources();
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to load resources", (Throwable)ex);
        }
        if (this.game.getServer() instanceof InternalServer) {
            this.game.getEventManager().registerListeners((Object)this, (Object)new WorldEventListener());
        }
        this.game.getEventManager().registerListeners((Object)this, (Object)new PlayerEventListener());
    }

    @Listener
    public void onServerStarted(GameStartedServerEvent e) {
        if (this.game.getServer() instanceof InternalServer) {
            this.updateTask = Task.builder().execute(() -> {
                for (World w : this.game.getServer().getWorlds()) {
                    for (NetworkChunk chunk : ((InternalWorld)w).getView().getLoadedChunkViews()) {
                        if (chunk.getState() != ChunkView.State.PREOBFUSCATED) continue;
                        chunk.obfuscate();
                    }
                }
            }).intervalTicks(1L).submit((Object)this);
            LOGGER.info("Mirage " + this.container.getVersion().orElse("?") + " was loaded successfully.");
        } else {
            LOGGER.error("!!WARNING!! Mirage was not loaded correctly. Be sure that the jar file is at the root of your mods folder!");
        }
        if (this.globalConfig.updateCheck.enabled) {
            Task.builder().async().interval((long)this.globalConfig.updateCheck.repetitionInterval, TimeUnit.HOURS).execute(this::checkForUpdate).submit((Object)this);
        }
    }

    @Listener
    public void onServerStopping(GameStoppingServerEvent e) {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
    }

    public void loadGlobalConfig() throws IOException, ObjectMappingException {
        CommentedConfigurationNode cfgNode;
        GlobalConfig cfg;
        if (this.globalConfig != null) {
            throw new IllegalStateException("Config already loaded");
        }
        Path file = this.configDir.resolve("global.conf");
        ConfigurationLoader<CommentedConfigurationNode> loader = this.createConfigLoader(file);
        CommentedConfigurationNode root = (CommentedConfigurationNode)loader.load();
        int version = root.getNode(new Object[]{"Version"}).getInt();
        if (version > 1 || version < 1) {
            version = 1;
            if (IOUtil.backupFile(file)) {
                LOGGER.info("Your global config version is not supported. A new one will be generated.");
                root = (CommentedConfigurationNode)loader.createEmptyNode();
            }
        }
        if ((cfg = (GlobalConfig)(cfgNode = root.getNode(new Object[]{"Config"})).getValue(GlobalConfig.TOKEN)) == null) {
            cfg = new GlobalConfig();
        }
        cfg.updateCheck.repetitionInterval = Math.max(cfg.updateCheck.repetitionInterval, 0);
        cfg.updateCheck.consoleDelay = MathUtil.clamp(cfg.updateCheck.consoleDelay, -1, 100);
        cfg.updateCheck.playerDelay = MathUtil.clamp(cfg.updateCheck.playerDelay, -1, 100);
        if (cfg.updateCheck.consoleDelay == -1 && cfg.updateCheck.playerDelay == -1) {
            cfg.updateCheck.enabled = false;
        }
        root.getNode(new Object[]{"Version"}).setValue((Object)version);
        cfgNode.setValue(GlobalConfig.TOKEN, (Object)cfg);
        loader.save((ConfigurationNode)root);
        this.globalConfig = cfg.toImmutable();
    }

    public void checkForUpdate() {
        String version = this.container.getVersion().orElse(null);
        if (version == null) {
            return;
        }
        LOGGER.debug("Checking for update ..");
        String latestVersion = null;
        try {
            latestVersion = OreAPI.getLatestVersion(OreAPI.getProjectVersions("mirage", new String[0]), (major, minor) -> major == 7).orElse(null);
        }
        catch (Exception e) {
            LOGGER.info("Failed to check for update", (Throwable)e);
        }
        if (latestVersion != null && !latestVersion.equals(version)) {
            LiteralText msg2;
            String downloadUrl = "https://ore.spongepowered.org/Yeregorix/Mirage/versions/" + latestVersion;
            Text msg1 = Text.join((Text[])new Text[]{Text.of((String)"A new version of Mirage is available: "), Text.builder((String)latestVersion).color(TextColors.AQUA).build(), Text.of((String)". You're currently using version: "), Text.builder((String)version).color(TextColors.AQUA).build(), Text.of((String)".")});
            try {
                msg2 = Text.builder((String)"Click here to open the download page.").color(TextColors.GOLD).onClick((ClickAction)TextActions.openUrl((URL)new URL(downloadUrl))).build();
            }
            catch (MalformedURLException e) {
                msg2 = null;
            }
            if (this.globalConfig.updateCheck.consoleDelay != -1) {
                Task.builder().delayTicks((long)this.globalConfig.updateCheck.consoleDelay).execute(() -> this.game.getServer().getConsole().sendMessage(msg1)).submit((Object)this);
            }
            if (this.globalConfig.updateCheck.playerDelay != -1) {
                Text[] textArray;
                if (msg2 == null) {
                    Text[] textArray2 = new Text[1];
                    textArray = textArray2;
                    textArray2[0] = msg1;
                } else {
                    Text[] textArray3 = new Text[2];
                    textArray3[0] = msg1;
                    textArray = textArray3;
                    textArray3[1] = msg2;
                }
                this.updateMessages = textArray;
            }
        }
    }

    public ConfigurationLoader<CommentedConfigurationNode> createConfigLoader(Path file) {
        return ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(file)).setDefaultOptions(this.configOptions)).build();
    }

    public Path getResourcesDirectory() {
        return this.resourcesDir;
    }

    public Path getWorldConfigsDirectory() {
        return this.worldConfigsDir;
    }

    public Path getCacheDirectory() {
        return this.cacheDir;
    }

    public GlobalConfig.Immutable getGlobalConfig() {
        if (this.globalConfig == null) {
            throw new IllegalStateException("Config not loaded");
        }
        return this.globalConfig;
    }

    public Text[] getUpdateMessages() {
        return this.updateMessages;
    }

    public PluginContainer getContainer() {
        return this.container;
    }

    public static Mirage get() {
        if (instance == null) {
            throw new IllegalStateException("Instance not available");
        }
        return instance;
    }
}

