/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.api.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.smoofyuniverse.mirage.util.collection.WeightedList;
import org.spongepowered.api.CatalogType;

public class Signature {
    public static final String DEFAULT_DIGEST_ALGORITHM = "sha-1";
    private static final Signature EMPTY = new Signature(new byte[0]);
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final byte[] bytes;

    public Signature(byte[] bytes) {
        if (bytes.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Max length: 32767");
        }
        this.bytes = bytes;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.bytes.length);
        out.write(this.bytes);
    }

    public boolean equals(Object obj) {
        return obj instanceof Signature && Arrays.equals(this.bytes, ((Signature)obj).bytes);
    }

    public String toString() {
        return Signature.toHexString(this.bytes);
    }

    public static Signature read(DataInputStream in) throws IOException {
        byte[] bytes = new byte[in.readShort()];
        in.readFully(bytes);
        return new Signature(bytes);
    }

    public static Signature empty() {
        return EMPTY;
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder s = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            s.append(hexchars[(b & 0xF0) >> 4]).append(hexchars[b & 0xF]);
        }
        return s.toString();
    }

    public static Builder builder() {
        return Signature.builder(DEFAULT_DIGEST_ALGORITHM);
    }

    public static Builder builder(String algorithm) {
        return new Builder(algorithm);
    }

    public static class Builder {
        private MessageDigest message;
        private byte[] buffer = new byte[8];

        private Builder(String algorithm) {
            try {
                this.message = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder reset() {
            this.message.reset();
            return this;
        }

        public Builder append(byte value) {
            this.message.update(value);
            return this;
        }

        public Builder append(short value) {
            this.buffer[0] = (byte)(value >>> 8);
            this.buffer[1] = (byte)value;
            this.appendBuffer(2);
            return this;
        }

        private void appendBuffer(int length) {
            this.message.update(this.buffer, 0, length);
        }

        public Builder append(float value) {
            return this.append(Float.floatToIntBits(value));
        }

        public Builder append(int value) {
            this.buffer[0] = (byte)(value >>> 24);
            this.buffer[1] = (byte)(value >>> 16);
            this.buffer[2] = (byte)(value >>> 8);
            this.buffer[3] = (byte)value;
            this.appendBuffer(4);
            return this;
        }

        public Builder append(double value) {
            return this.append(Double.doubleToLongBits(value));
        }

        public Builder append(long value) {
            this.buffer[0] = (byte)(value >>> 56);
            this.buffer[1] = (byte)(value >>> 48);
            this.buffer[2] = (byte)(value >>> 40);
            this.buffer[3] = (byte)(value >>> 32);
            this.buffer[4] = (byte)(value >>> 24);
            this.buffer[5] = (byte)(value >>> 16);
            this.buffer[6] = (byte)(value >>> 8);
            this.buffer[7] = (byte)value;
            this.appendBuffer(8);
            return this;
        }

        public Builder append(Iterable<? extends CatalogType> it) {
            for (CatalogType catalogType : it) {
                this.append(catalogType);
            }
            return this;
        }

        public Builder append(CatalogType type) {
            return type == null ? this.append(0) : this.append(type.getId());
        }

        public Builder append(String value) {
            char c;
            int strlen = value.length();
            int utflen = 0;
            int count = 0;
            for (int i = 0; i < strlen; ++i) {
                c = value.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c > '\u07ff') {
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
            if (utflen > 65535) {
                throw new IllegalArgumentException("Encoded string too long: " + utflen + " bytes");
            }
            byte[] bytearr = new byte[utflen];
            for (int i = 0; i < strlen; ++i) {
                c = value.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    bytearr[count++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                    bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                    bytearr[count++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            }
            return this.append(bytearr);
        }

        public Builder append(byte[] bytes) {
            return this.append(bytes, 0, bytes.length);
        }

        public Builder append(byte[] bytes, int offset, int length) {
            this.message.update(bytes, offset, length);
            return this;
        }

        public Builder append(WeightedList<? extends CatalogType> list) {
            list.forEach((b, w) -> this.append((CatalogType)b).append(w));
            return this;
        }

        public Signature build() {
            return new Signature(this.message.digest());
        }
    }
}

