/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.api.volume;

import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.math.vector.Vectori;
import net.smoofyuniverse.mirage.api.volume.BlockView;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;

public interface BlockStorage
extends ImmutableBlockVolume {
    public BlockView getView();

    default public void checkBlockArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.checkBlockPosition(minX, minY, minZ);
        this.checkBlockPosition(maxX, maxY, maxZ);
        if (minX > maxX || minY > maxY || minZ > maxZ) {
            throw new IllegalArgumentException("Invalid area");
        }
    }

    default public void checkBlockPosition(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)this.getBlockMin(), (Vectori)this.getBlockMax());
        }
    }

    default public boolean isExposed(Vector3i pos) {
        return this.isExposed(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean isExposed(int var1, int var2, int var3);

    default public int getBlockLightLevel(Vector3i pos) {
        return this.getBlockLightLevel(pos.getX(), pos.getY(), pos.getZ());
    }

    public int getBlockLightLevel(int var1, int var2, int var3);

    default public boolean canSeeTheSky(Vector3i pos) {
        return this.canSeeTheSky(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean canSeeTheSky(int var1, int var2, int var3);
}

