/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.api.volume;

import com.flowpowered.math.vector.Vector3i;
import java.util.Optional;
import net.smoofyuniverse.mirage.api.volume.BlockView;
import net.smoofyuniverse.mirage.api.volume.ChunkStorage;
import net.smoofyuniverse.mirage.api.volume.WorldView;
import org.spongepowered.api.util.Direction;

public interface ChunkView
extends BlockView {
    @Override
    public ChunkStorage getStorage();

    default public boolean isNeighborLoaded(Direction dir) {
        return this.getNeighborView(dir).isPresent();
    }

    default public Optional<ChunkView> getNeighborView(Direction dir) {
        if (dir.isSecondaryOrdinal()) {
            throw new IllegalArgumentException("Direction");
        }
        return this.getWorld().getChunkView(this.getPosition().add(dir.asBlockOffset()));
    }

    public WorldView getWorld();

    public Vector3i getPosition();

    public boolean areNeighborsLoaded();

    public State getState();

    public void obfuscate();

    public void deobfuscate();

    public void reobfuscate();

    public void clearDynamism();

    public static enum State {
        DEOBFUSCATED,
        PREOBFUSCATED,
        OBFUSCATED;

    }
}

