/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.api.volume;

import com.flowpowered.math.vector.Vector3i;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.smoofyuniverse.mirage.api.modifier.ConfiguredModifier;
import net.smoofyuniverse.mirage.api.volume.BlockView;
import net.smoofyuniverse.mirage.api.volume.ChunkView;
import net.smoofyuniverse.mirage.api.volume.WorldStorage;
import net.smoofyuniverse.mirage.config.world.DeobfuscationConfig;
import net.smoofyuniverse.mirage.config.world.WorldConfig;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.world.storage.WorldProperties;

public interface WorldView
extends BlockView,
Identifiable {
    @Override
    public WorldStorage getStorage();

    public String getName();

    public WorldProperties getProperties();

    public List<ConfiguredModifier> getModifiers();

    public WorldConfig.Immutable getConfig();

    public boolean isEnabled();

    default public boolean isChunkLoaded(Vector3i pos) {
        return this.isChunkLoaded(pos.getX(), pos.getY(), pos.getZ());
    }

    default public boolean isChunkLoaded(int x, int y, int z) {
        return this.getChunkView(x, y, z).isPresent();
    }

    public Optional<ChunkView> getChunkView(int var1, int var2, int var3);

    default public Optional<ChunkView> getChunkView(Vector3i pos) {
        return this.getChunkView(pos.getX(), pos.getY(), pos.getZ());
    }

    default public Optional<ChunkView> getChunkViewAt(Vector3i pos) {
        return this.getChunkViewAt(pos.getX(), pos.getY(), pos.getZ());
    }

    public Optional<ChunkView> getChunkViewAt(int var1, int var2, int var3);

    public Collection<? extends ChunkView> getLoadedChunkViews();

    default public void deobfuscateSurrounding(Vector3i pos, boolean player, boolean silentFail) {
        this.deobfuscateSurrounding(pos.getX(), pos.getY(), pos.getZ(), player, silentFail);
    }

    default public void deobfuscateSurrounding(int x, int y, int z, boolean player, boolean silentFail) {
        DeobfuscationConfig.Immutable cfg = this.getConfig().deobf;
        this.deobfuscateSurrounding(x, y, z, player ? cfg.playerRadius : cfg.naturalRadius, silentFail);
    }

    default public void reobfuscateSurrounding(Vector3i pos, boolean player, boolean silentFail) {
        this.reobfuscateSurrounding(pos.getX(), pos.getY(), pos.getZ(), player, silentFail);
    }

    default public void reobfuscateSurrounding(int x, int y, int z, boolean player, boolean silentFail) {
        DeobfuscationConfig.Immutable cfg = this.getConfig().deobf;
        this.reobfuscateSurrounding(x, y, z, player ? cfg.playerRadius : cfg.naturalRadius, silentFail);
    }
}

