/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.config.world;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import net.smoofyuniverse.mirage.util.collection.BlockSet;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.block.BlockState;

@ConfigSerializable
public class PreobfuscationConfig {
    @Setting(value="Enabled", comment="Enable or disable preobfuscation in this world")
    public boolean enabled = false;
    @Setting(value="Blocks", comment="Blocks that will be hidden by the modifier")
    public BlockSet blocks;
    @Setting(value="Replacement", comment="The block used to replace hidden blocks")
    public BlockState replacement;

    public Immutable toImmutable() {
        return new Immutable(this.enabled, this.blocks.getAll(), this.replacement);
    }

    public static class Immutable {
        public final boolean enabled;
        public final Set<BlockState> blocks;
        public final BlockState replacement;

        public Immutable(boolean enabled, Collection<BlockState> blocks, BlockState replacement) {
            this.enabled = enabled;
            this.blocks = ImmutableSet.copyOf(blocks);
            this.replacement = replacement;
        }
    }
}

