/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.event;

import com.flowpowered.math.vector.Vector3i;
import java.util.HashSet;
import net.smoofyuniverse.mirage.impl.internal.InternalWorld;
import net.smoofyuniverse.mirage.impl.network.NetworkChunk;
import net.smoofyuniverse.mirage.impl.network.NetworkWorld;
import net.smoofyuniverse.mirage.util.BlockUtil;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.event.world.SaveWorldEvent;
import org.spongepowered.api.world.Location;

public class WorldEventListener {
    @Listener
    public void onWorldSave(SaveWorldEvent.Pre e) {
        ((InternalWorld)e.getTargetWorld()).getView().getLoadedChunkViews().forEach(NetworkChunk::saveToCacheLater);
    }

    @Exclude(value={ChangeBlockEvent.Post.class})
    @Listener(order=Order.POST)
    public void onBlockChange(ChangeBlockEvent e) {
        boolean player = e.getCause().containsType(Player.class);
        for (Transaction t : e.getTransactions()) {
            Location loc;
            boolean isOpaque;
            BlockSnapshot original;
            boolean wasOpaque;
            if (!t.isValid() || (wasOpaque = BlockUtil.isOpaque((original = (BlockSnapshot)t.getOriginal()).getState())) == (isOpaque = BlockUtil.isOpaque(((BlockSnapshot)t.getFinal()).getState())) || (loc = (Location)original.getLocation().orElse(null)) == null) continue;
            NetworkWorld world = ((InternalWorld)loc.getExtent()).getView();
            Vector3i pos = loc.getBlockPosition();
            if (isOpaque) {
                world.reobfuscateSurrounding(pos, player, true);
                continue;
            }
            world.deobfuscateSurrounding(pos, player, true);
        }
    }

    @Listener(order=Order.POST)
    public void onExplosionDetonate(ExplosionEvent.Detonate e) {
        HashSet<Vector3i> blocks = new HashSet<Vector3i>();
        for (Location loc : e.getAffectedLocations()) {
            Vector3i pos = loc.getBlockPosition();
            blocks.add(pos.add(1, 0, 0));
            blocks.add(pos.add(-1, 0, 0));
            blocks.add(pos.add(0, 1, 0));
            blocks.add(pos.add(0, -1, 0));
            blocks.add(pos.add(0, 0, 1));
            blocks.add(pos.add(0, 0, -1));
        }
        for (Location loc : e.getAffectedLocations()) {
            blocks.remove(loc.getBlockPosition());
        }
        NetworkWorld world = ((InternalWorld)e.getTargetWorld()).getView();
        for (Vector3i pos : blocks) {
            world.deobfuscate(pos);
        }
    }
}

