/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.impl.network.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;

public class BlockContainerSnapshot {
    private byte[] blockIds;
    private byte[] data;
    private byte[] extension;
    private byte[] dynamism;
    private int section;

    public int getSection() {
        return this.section;
    }

    public void setSection(int section) {
        this.section = section;
    }

    public byte[] getBlockIds() {
        return this.blockIds;
    }

    public void setBlockIds(byte[] blockIds) {
        if (blockIds == null || blockIds.length != 4096) {
            throw new IllegalArgumentException();
        }
        this.blockIds = blockIds;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        if (data == null || data.length != 2048) {
            throw new IllegalArgumentException();
        }
        this.data = data;
    }

    @Nullable
    public byte[] getExtension() {
        return this.extension;
    }

    public void setExtension(@Nullable byte[] extension) {
        if (extension != null && extension.length != 2048) {
            throw new IllegalArgumentException();
        }
        this.extension = extension;
    }

    public byte[] getDynamism() {
        return this.dynamism;
    }

    public void setDynamism(byte[] dynamism) {
        if (dynamism == null || dynamism.length != 2048) {
            throw new IllegalArgumentException();
        }
        this.dynamism = dynamism;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.section);
        out.write(this.blockIds);
        out.write(this.data);
        if (this.extension == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.write(this.extension);
        }
        if (BlockContainerSnapshot.isEmpty(this.dynamism)) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.write(this.dynamism);
        }
    }

    private static boolean isEmpty(byte[] array) {
        for (byte b : array) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public BlockContainerSnapshot read(DataInputStream in, int version) throws IOException {
        if (version < 1 || version > 1) {
            throw new IllegalArgumentException("version");
        }
        this.section = in.readInt();
        this.blockIds = new byte[4096];
        in.readFully(this.blockIds);
        this.data = new byte[2048];
        in.readFully(this.data);
        if (in.readBoolean()) {
            this.extension = new byte[2048];
            in.readFully(this.extension);
        } else {
            this.extension = null;
        }
        this.dynamism = new byte[2048];
        if (in.readBoolean()) {
            in.readFully(this.dynamism);
        }
        return this;
    }
}

