/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.impl.network.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.world.chunk.storage.RegionFile;

public class NetworkRegionFile {
    private RegionFile delegate;
    private boolean closed;
    private Path file;

    public NetworkRegionFile(Path file) {
        this.delegate = new RegionFile(file.toFile());
        this.file = file;
    }

    public Path getFile() {
        return this.file;
    }

    public boolean exists(int x, int z) {
        this.checkBounds(x, z);
        return this.delegate.func_76709_c(x, z);
    }

    private void checkBounds(int x, int z) {
        if (!this.contains(x, z)) {
            throw new IllegalArgumentException();
        }
    }

    public boolean contains(int x, int z) {
        return x >= 0 && z >= 0 && x < 32 && z < 32;
    }

    @Nullable
    public DataInputStream getDataInputStream(int x, int z) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        this.checkBounds(x, z);
        return this.delegate.func_76704_a(x, z);
    }

    public DataOutputStream getDataOutputStream(int x, int z) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        this.checkBounds(x, z);
        return this.delegate.func_76710_b(x, z);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.delegate.func_76708_c();
            this.closed = true;
        }
    }
}

