/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.impl.network.change;

import com.flowpowered.math.vector.Vector3i;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketMultiBlockChange;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.smoofyuniverse.mirage.impl.internal.InternalChunk;
import net.smoofyuniverse.mirage.impl.internal.compat.CompatUtil;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.entity.living.player.Player;

public class BlockChange {
    private final Packet<?>[] packets;

    private BlockChange(Packet<?> ... packets) {
        this.packets = packets;
    }

    private BlockChange() {
        this.packets = null;
    }

    public void sendTo(Player player) {
        if (this.packets != null) {
            for (Packet<?> packet : this.packets) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a(packet);
            }
        }
    }

    public void sendTo(Iterable<Player> players) {
        if (this.packets != null) {
            for (Player p : players) {
                for (Packet<?> packet : this.packets) {
                    ((EntityPlayerMP)p).field_71135_a.func_147359_a(packet);
                }
            }
        }
    }

    public static Builder builder(InternalChunk chunk) {
        return new Builder((Chunk)chunk);
    }

    public static class Builder {
        private final Short2ObjectMap<IBlockState> blocks = new Short2ObjectOpenHashMap();
        private final World nmsWorld;
        private final int x;
        private final int z;

        private Builder(Chunk nmsChunk) {
            this.nmsWorld = nmsChunk.func_177412_p();
            this.x = nmsChunk.field_76635_g;
            this.z = nmsChunk.field_76647_h;
        }

        public void add(Vector3i pos, BlockState state) {
            this.add(pos.getX(), pos.getY(), pos.getZ(), state);
        }

        public void add(int x, int y, int z, BlockState state) {
            this.add((short)((x & 0xF) << 12 | (z & 0xF) << 8 | y & 0xFF), state);
        }

        public void add(short index, BlockState state) {
            this.blocks.put(index, (Object)((IBlockState)state));
        }

        public BlockChange build(boolean tileEntities) {
            int changes = this.blocks.size();
            if (changes == 0) {
                return new BlockChange();
            }
            int minX = this.x << 4;
            int minZ = this.z << 4;
            if (changes == 1) {
                SPacketUpdateTileEntity packet2;
                TileEntity te;
                SPacketBlockChange packet = new SPacketBlockChange();
                Short2ObjectMap.Entry e = (Short2ObjectMap.Entry)this.blocks.short2ObjectEntrySet().iterator().next();
                short pos = e.getShortKey();
                packet.field_179828_a = new BlockPos(minX + (pos >> 12 & 0xF), pos & 0xFF, minZ + (pos >> 8 & 0xF));
                packet.field_148883_d = (IBlockState)e.getValue();
                if (tileEntities && CompatUtil.hasTileEntity(packet.field_148883_d) && (te = this.nmsWorld.func_175625_s(packet.field_179828_a)) != null && (packet2 = te.func_189518_D_()) != null) {
                    return new BlockChange(new Packet[]{packet, packet2});
                }
                return new BlockChange(new Packet[]{packet});
            }
            SPacketMultiBlockChange packet = new SPacketMultiBlockChange();
            packet.field_148925_b = new ChunkPos(this.x, this.z);
            packet.field_179845_b = new SPacketMultiBlockChange.BlockUpdateData[changes];
            int i = 0;
            for (Short2ObjectMap.Entry e : this.blocks.short2ObjectEntrySet()) {
                SPacketMultiBlockChange.BlockUpdateData[] blockUpdateDataArray = packet.field_179845_b;
                int n = i++;
                SPacketMultiBlockChange sPacketMultiBlockChange = packet;
                sPacketMultiBlockChange.getClass();
                blockUpdateDataArray[n] = new SPacketMultiBlockChange.BlockUpdateData(sPacketMultiBlockChange, e.getShortKey(), (IBlockState)e.getValue());
            }
            if (tileEntities) {
                ArrayList<Object> packets = new ArrayList<Object>();
                packets.add(packet);
                for (SPacketMultiBlockChange.BlockUpdateData b : packet.field_179845_b) {
                    SPacketUpdateTileEntity packet2;
                    short pos;
                    TileEntity te;
                    if (!CompatUtil.hasTileEntity(b.field_180092_c) || (te = this.nmsWorld.func_175625_s(new BlockPos(minX + ((pos = b.field_180091_b) >> 12 & 0xF), pos & 0xFF, minZ + (pos >> 8 & 0xF)))) == null || (packet2 = te.func_189518_D_()) == null) continue;
                    packets.add(packet2);
                }
                return new BlockChange(packets.toArray(new Packet[0]));
            }
            return new BlockChange(new Packet[]{packet});
        }
    }
}

