/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.impl.network.dynamism;

import com.flowpowered.math.vector.Vector3i;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import javax.annotation.Nullable;
import net.smoofyuniverse.mirage.impl.internal.InternalChunk;
import net.smoofyuniverse.mirage.impl.network.NetworkChunk;
import net.smoofyuniverse.mirage.impl.network.change.BlockChange;
import net.smoofyuniverse.mirage.util.MathUtil;

public final class DynamicChunk {
    public final int x;
    public final int z;
    private ShortSet nextPositions = new ShortOpenHashSet();
    private ShortSet currentPositions = new ShortOpenHashSet();
    private boolean modified;
    private Vector3i center;
    private int relCenterX;
    private int relCenterY;
    private int relCenterZ;

    public DynamicChunk(int x, int z) {
        this.x = x;
        this.z = z;
    }

    @Nullable
    public Vector3i getCenter() {
        return this.center;
    }

    public void setCenter(Vector3i center) {
        this.center = center;
        if (center != null) {
            this.relCenterX = center.getX() - (this.x << 4);
            this.relCenterY = center.getY();
            this.relCenterZ = center.getZ() - (this.z << 4);
        }
    }

    public void update(int x, int y, int z, int distance) {
        if (this.center == null) {
            return;
        }
        if (MathUtil.lengthSquared(this.relCenterX - x, this.relCenterY - y, this.relCenterZ - z) <= MathUtil.squared(distance) << 8) {
            this.add(x, y, z);
        } else {
            this.remove(x, y, z);
        }
    }

    public void add(int x, int y, int z) {
        this.add(DynamicChunk.index(x, y, z));
    }

    public void remove(int x, int y, int z) {
        this.remove(DynamicChunk.index(x, y, z));
    }

    public void add(short pos) {
        if (this.nextPositions.add(pos)) {
            this.modified = true;
        }
    }

    private static short index(int x, int y, int z) {
        return (short)((x & 0xF) << 12 | (z & 0xF) << 8 | y & 0xFF);
    }

    public void remove(short pos) {
        if (this.nextPositions.rem(pos)) {
            this.modified = true;
        }
    }

    public void clear() {
        if (!this.nextPositions.isEmpty()) {
            this.nextPositions.clear();
            this.modified = true;
        }
    }

    public boolean currentlyContains(int x, int y, int z) {
        return this.currentlyContains(DynamicChunk.index(x, y, z));
    }

    public boolean currentlyContains(short pos) {
        return this.currentPositions.contains(pos);
    }

    public BlockChange getChanges(InternalChunk chunk, boolean tileEntities) {
        BlockChange.Builder b = BlockChange.builder(chunk);
        this.getChanges(chunk, b);
        return b.build(tileEntities);
    }

    public void getChanges(InternalChunk chunk, BlockChange.Builder b) {
        if (this.modified) {
            short pos;
            NetworkChunk netChunk = chunk.getView();
            if (netChunk.x != this.x || netChunk.z != this.z) {
                throw new IllegalArgumentException("Chunk pos");
            }
            int minX = this.x << 4;
            int minZ = this.z << 4;
            ShortIterator it = this.nextPositions.iterator();
            while (it.hasNext()) {
                pos = it.nextShort();
                if (this.currentPositions.contains(pos)) continue;
                b.add(pos, chunk.getBlock(minX + (pos >> 12 & 0xF), pos & 0xFF, minZ + (pos >> 8 & 0xF)));
            }
            it = this.currentPositions.iterator();
            while (it.hasNext()) {
                pos = it.nextShort();
                if (this.nextPositions.contains(pos)) continue;
                b.add(pos, netChunk.getBlock(minX + (pos >> 12 & 0xF), pos & 0xFF, minZ + (pos >> 8 & 0xF)));
            }
        }
    }

    public BlockChange getCurrent(InternalChunk chunk, boolean tileEntities) {
        return this.getCurrent(chunk, 65535, tileEntities);
    }

    public BlockChange getCurrent(InternalChunk chunk, int sections, boolean tileEntities) {
        BlockChange.Builder b = BlockChange.builder(chunk);
        this.getCurrent(chunk, sections, b);
        return b.build(tileEntities);
    }

    public void getCurrent(InternalChunk chunk, int sections, BlockChange.Builder b) {
        if (sections == 0) {
            return;
        }
        NetworkChunk netChunk = chunk.getView();
        if (netChunk.x != this.x || netChunk.z != this.z) {
            throw new IllegalArgumentException("Chunk pos");
        }
        int minX = this.x << 4;
        int minZ = this.z << 4;
        ShortIterator it = this.currentPositions.iterator();
        if (sections == 65535) {
            while (it.hasNext()) {
                short pos = it.nextShort();
                b.add(pos, chunk.getBlock(minX + (pos >> 12 & 0xF), pos & 0xFF, minZ + (pos >> 8 & 0xF)));
            }
        } else {
            while (it.hasNext()) {
                short pos = it.nextShort();
                int y = pos & 0xFF;
                if ((sections & 1 << (y >> 4)) == 0) continue;
                b.add(pos, chunk.getBlock(minX + (pos >> 12 & 0xF), y, minZ + (pos >> 8 & 0xF)));
            }
        }
    }

    public void getCurrent(InternalChunk chunk, BlockChange.Builder b) {
        this.getCurrent(chunk, 65535, b);
    }

    public boolean hasChanges() {
        return this.modified;
    }

    public void applyChanges() {
        if (this.modified) {
            this.currentPositions.clear();
            this.currentPositions.addAll((ShortCollection)this.nextPositions);
            this.modified = false;
        }
    }
}

