/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.impl.network.dynamism;

import com.flowpowered.math.vector.Vector3i;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;
import java.util.UUID;
import net.smoofyuniverse.mirage.MirageTimings;
import net.smoofyuniverse.mirage.impl.internal.InternalChunk;
import net.smoofyuniverse.mirage.impl.network.change.ChunkChangeListener;
import net.smoofyuniverse.mirage.impl.network.dynamism.DynamicChunk;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.Tuple;

public final class PlayerDynamismManager {
    public final UUID playerId;
    private Long2ObjectMap<Tuple<DynamicChunk, ChunkChangeListener>> chunks = new Long2ObjectOpenHashMap();
    private Vector3i center;

    public PlayerDynamismManager(UUID playerId) {
        this.playerId = playerId;
    }

    public void update(Player player) {
        if (!player.getUniqueId().equals(this.playerId)) {
            throw new IllegalArgumentException("Player");
        }
        Vector3i pos = player.getPosition().toInt();
        if (this.center == null || !this.center.equals((Object)pos)) {
            this.setCenter(pos);
        }
    }

    private void setCenter(DynamicChunk dynChunk, ChunkChangeListener listener) {
        dynChunk.setCenter(this.center);
        dynChunk.clear();
        InternalChunk chunk = listener.getChunk();
        if (chunk != null) {
            chunk.getView().collectDynamicPositions(dynChunk);
            listener.markDirty();
        }
    }

    public Optional<Vector3i> getCenter() {
        return Optional.ofNullable(this.center);
    }

    public void setCenter(Vector3i center) {
        MirageTimings.DYNAMISM.startTiming();
        this.center = center;
        for (Tuple t : this.chunks.values()) {
            this.setCenter((DynamicChunk)t.getFirst(), (ChunkChangeListener)t.getSecond());
        }
        MirageTimings.DYNAMISM.stopTiming();
    }

    public void addChunk(DynamicChunk dynChunk, ChunkChangeListener listener) {
        if (dynChunk == null || listener == null) {
            throw new IllegalArgumentException();
        }
        this.chunks.put(PlayerDynamismManager.index(dynChunk.x, dynChunk.z), (Object)new Tuple((Object)dynChunk, (Object)listener));
        if (this.center != null) {
            MirageTimings.DYNAMISM.startTiming();
            this.setCenter(dynChunk, listener);
            MirageTimings.DYNAMISM.stopTiming();
        }
    }

    private static long index(int x, int z) {
        return (long)x + Integer.MAX_VALUE | (long)z + Integer.MAX_VALUE << 32;
    }

    public void removeChunk(int x, int z) {
        this.chunks.remove(PlayerDynamismManager.index(x, z));
    }
}

