/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.mixin.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.smoofyuniverse.mirage.MirageTimings;
import net.smoofyuniverse.mirage.impl.internal.InternalChunk;
import net.smoofyuniverse.mirage.impl.internal.InternalChunkMap;
import net.smoofyuniverse.mirage.impl.internal.compat.CompatUtil;
import net.smoofyuniverse.mirage.impl.network.NetworkChunk;
import net.smoofyuniverse.mirage.impl.network.change.BlockChange;
import net.smoofyuniverse.mirage.impl.network.change.ChunkChangeListener;
import net.smoofyuniverse.mirage.impl.network.dynamism.DynamicChunk;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerChunkMapEntry.class}, priority=900)
public abstract class MixinPlayerChunkMapEntry
implements ChunkChangeListener {
    @Shadow
    private Chunk field_187286_f;
    @Shadow
    private int field_187287_g;
    @Shadow
    private int field_187288_h;
    @Shadow
    private boolean field_187290_j;
    @Shadow
    @Final
    private List<EntityPlayerMP> field_187283_c;
    @Shadow
    private short[] field_187285_e;
    @Shadow
    @Final
    private ChunkPos field_187284_d;
    @Shadow
    @Final
    private PlayerChunkMap field_187282_b;
    private Map<EntityPlayerMP, DynamicChunk> dynamicChunks;
    private boolean dynamismEnabled;
    private boolean dirty;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onInit(CallbackInfo ci) {
        this.dynamismEnabled = ((InternalChunkMap)this.field_187282_b).isDynamismEnabled();
        if (this.dynamismEnabled) {
            this.dynamicChunks = new HashMap<EntityPlayerMP, DynamicChunk>();
        }
    }

    @Inject(method={"addPlayer"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", shift=At.Shift.AFTER)})
    public void onAddPlayer(EntityPlayerMP player, CallbackInfo ci) {
        if (this.field_187290_j && this.dynamismEnabled) {
            this.addDynamicChunk(player);
        }
    }

    private void addDynamicChunk(EntityPlayerMP player) {
        DynamicChunk chunk = new DynamicChunk(this.field_187284_d.field_77276_a, this.field_187284_d.field_77275_b);
        this.dynamicChunks.put(player, chunk);
        ((InternalChunkMap)this.field_187282_b).getOrCreateDynamismManager((Player)player).addChunk(chunk, this);
    }

    @Inject(method={"removePlayer"}, at={@At(value="INVOKE", target="Ljava/util/List;remove(Ljava/lang/Object;)Z", shift=At.Shift.AFTER)})
    public void onRemovePlayer(EntityPlayerMP player, CallbackInfo ci) {
        if (this.field_187290_j && this.dynamismEnabled) {
            this.removeDynamicChunk(player);
        }
    }

    private void removeDynamicChunk(EntityPlayerMP player) {
        this.dynamicChunks.remove(player);
        ((InternalChunkMap)this.field_187282_b).getDynamismManager(player.func_110124_au()).ifPresent(m -> m.removeChunk(this.field_187284_d.field_77276_a, this.field_187284_d.field_77275_b));
    }

    @Overwrite
    public boolean func_187272_b() {
        if (this.field_187290_j) {
            return true;
        }
        if (this.field_187286_f == null || !this.field_187286_f.func_150802_k()) {
            return false;
        }
        InternalChunk chunk = (InternalChunk)this.field_187286_f;
        if (chunk.isViewAvailable()) {
            chunk.getView().obfuscate();
        }
        this.clearChanges();
        this.field_187290_j = true;
        if (chunk.isViewAvailable()) {
            chunk.getView().setListener(this);
        }
        if (this.field_187283_c.isEmpty()) {
            return true;
        }
        if (this.dynamismEnabled) {
            for (EntityPlayerMP p : this.field_187283_c) {
                this.addDynamicChunk(p);
            }
            SPacketChunkData packet = new SPacketChunkData(this.field_187286_f, 65535);
            for (Map.Entry<EntityPlayerMP, DynamicChunk> e : this.dynamicChunks.entrySet()) {
                EntityPlayerMP p = e.getKey();
                DynamicChunk dynChunk = e.getValue();
                p.field_71135_a.func_147359_a((Packet)packet);
                MirageTimings.DYNAMISM.startTiming();
                dynChunk.applyChanges();
                dynChunk.getCurrent(chunk, true).sendTo((Player)p);
                MirageTimings.DYNAMISM.stopTiming();
                this.field_187282_b.func_72688_a().func_73039_n().func_85172_a(p, this.field_187286_f);
                CompatUtil.postChunkWatchEvent(this.field_187286_f, p);
            }
        } else {
            SPacketChunkData packet = new SPacketChunkData(this.field_187286_f, 65535);
            for (EntityPlayerMP p : this.field_187283_c) {
                p.field_71135_a.func_147359_a((Packet)packet);
                this.field_187282_b.func_72688_a().func_73039_n().func_85172_a(p, this.field_187286_f);
                CompatUtil.postChunkWatchEvent(this.field_187286_f, p);
            }
        }
        return true;
    }

    @Overwrite
    public void func_187278_c(EntityPlayerMP p) {
        if (this.field_187290_j) {
            p.field_71135_a.func_147359_a((Packet)new SPacketChunkData(this.field_187286_f, 65535));
            if (this.dynamismEnabled) {
                MirageTimings.DYNAMISM.startTiming();
                DynamicChunk dynChunk = this.dynamicChunks.get(p);
                if (dynChunk != null) {
                    dynChunk.applyChanges();
                    dynChunk.getCurrent((InternalChunk)this.field_187286_f, true).sendTo((Player)p);
                }
                MirageTimings.DYNAMISM.stopTiming();
            }
            this.field_187282_b.func_72688_a().func_73039_n().func_85172_a(p, this.field_187286_f);
        }
    }

    @Overwrite
    public void func_187265_a(int x, int y, int z) {
        if (this.field_187290_j) {
            this.field_187288_h |= 1 << (y >> 4);
            if (this.field_187287_g < 64) {
                short pos = (short)(x << 12 | z << 8 | y);
                for (int i = 0; i < this.field_187287_g; ++i) {
                    if (this.field_187285_e[i] != pos) continue;
                    return;
                }
                this.field_187285_e[this.field_187287_g++] = pos;
            }
            this.markDirty();
        }
    }

    @Overwrite
    public void func_187280_d() {
        if (this.field_187290_j) {
            this.dirty = false;
            if (this.field_187287_g == 0) {
                if (this.dynamismEnabled) {
                    InternalChunk chunk = (InternalChunk)this.field_187286_f;
                    MirageTimings.DYNAMISM.startTiming();
                    for (Map.Entry<EntityPlayerMP, DynamicChunk> e : this.dynamicChunks.entrySet()) {
                        DynamicChunk dynChunk = e.getValue();
                        if (!dynChunk.hasChanges()) continue;
                        BlockChange.Builder b = BlockChange.builder(chunk);
                        dynChunk.getChanges(chunk, b);
                        dynChunk.applyChanges();
                        b.build(true).sendTo((Player)e.getKey());
                    }
                    MirageTimings.DYNAMISM.stopTiming();
                }
            } else {
                if (this.field_187287_g >= 64) {
                    this.func_187267_a((Packet<?>)new SPacketChunkData(this.field_187286_f, this.field_187288_h));
                } else {
                    InternalChunk chunk = (InternalChunk)this.field_187286_f;
                    int minX = this.field_187284_d.field_77276_a << 4;
                    int minZ = this.field_187284_d.field_77275_b << 4;
                    if (this.dynamismEnabled) {
                        NetworkChunk netChunk = chunk.getView();
                        MirageTimings.DYNAMISM.startTiming();
                        for (Map.Entry<EntityPlayerMP, DynamicChunk> e : this.dynamicChunks.entrySet()) {
                            EntityPlayerMP p = e.getKey();
                            DynamicChunk dynChunk = e.getValue();
                            BlockChange.Builder b = BlockChange.builder(chunk);
                            for (int i = 0; i < this.field_187287_g; ++i) {
                                short pos;
                                b.add(pos, (dynChunk.currentlyContains(pos = this.field_187285_e[i]) ? chunk : netChunk).getBlock(minX + (pos >> 12 & 0xF), pos & 0xFF, minZ + (pos >> 8 & 0xF)));
                            }
                            dynChunk.getChanges(chunk, b);
                            dynChunk.applyChanges();
                            b.build(true).sendTo((Player)p);
                        }
                        MirageTimings.DYNAMISM.stopTiming();
                    } else {
                        Object volume = chunk.isViewAvailable() ? chunk.getView() : chunk;
                        BlockChange.Builder b = BlockChange.builder(chunk);
                        for (int i = 0; i < this.field_187287_g; ++i) {
                            short pos = this.field_187285_e[i];
                            b.add(pos, volume.getBlock(minX + (pos >> 12 & 0xF), pos & 0xFF, minZ + (pos >> 8 & 0xF)));
                        }
                        b.build(true).sendTo(this.field_187283_c);
                    }
                }
                this.clearChanges();
            }
        }
    }

    @Overwrite
    public void func_187267_a(Packet<?> packet) {
        block5: {
            if (!this.field_187290_j) break block5;
            if (this.dynamismEnabled && packet instanceof SPacketChunkData) {
                SPacketChunkData data = (SPacketChunkData)packet;
                if (data.field_149284_a != this.field_187284_d.field_77276_a || data.field_149282_b != this.field_187284_d.field_77275_b) {
                    throw new IllegalArgumentException("Chunk pos");
                }
                InternalChunk chunk = (InternalChunk)this.field_187286_f;
                int sections = data.func_149274_i() ? 65535 : data.field_186948_c;
                for (Map.Entry<EntityPlayerMP, DynamicChunk> e : this.dynamicChunks.entrySet()) {
                    EntityPlayerMP p = e.getKey();
                    DynamicChunk dynChunk = e.getValue();
                    p.field_71135_a.func_147359_a(packet);
                    MirageTimings.DYNAMISM.startTiming();
                    dynChunk.applyChanges();
                    dynChunk.getCurrent(chunk, sections, true).sendTo((Player)p);
                    MirageTimings.DYNAMISM.stopTiming();
                }
            } else {
                for (EntityPlayerMP p : this.field_187283_c) {
                    p.field_71135_a.func_147359_a(packet);
                }
            }
        }
    }

    @Override
    @Nullable
    public InternalChunk getChunk() {
        return (InternalChunk)this.field_187286_f;
    }

    @Override
    public void addChange(int x, int y, int z) {
        this.func_187265_a(x, y, z);
    }

    @Override
    public void sendChanges() {
        this.func_187280_d();
    }

    @Override
    public void clearChanges() {
        this.field_187287_g = 0;
        this.field_187288_h = 0;
    }

    @Override
    public void updateDynamism(int x, int y, int z, int distance) {
        if (this.field_187290_j && this.dynamismEnabled) {
            for (DynamicChunk chunk : this.dynamicChunks.values()) {
                chunk.update(x, y, z, distance);
            }
            this.markDirty();
        }
    }

    @Override
    public void clearDynamism() {
        if (this.field_187290_j && this.dynamismEnabled) {
            this.dynamicChunks.values().forEach(DynamicChunk::clear);
            this.markDirty();
        }
    }

    @Override
    public void markDirty() {
        if (this.field_187290_j && !this.dirty) {
            this.field_187282_b.func_187304_a((PlayerChunkMapEntry)this);
            this.dirty = true;
        }
    }
}

