/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.modifier;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.reflect.TypeToken;
import java.util.Random;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.api.cache.Signature;
import net.smoofyuniverse.mirage.api.modifier.ChunkModifier;
import net.smoofyuniverse.mirage.api.volume.BlockView;
import net.smoofyuniverse.mirage.api.volume.ChunkView;
import net.smoofyuniverse.mirage.resource.Resources;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.storage.WorldProperties;

public class BedrockModifier
extends ChunkModifier {
    public BedrockModifier() {
        super(Mirage.get(), "Bedrock");
    }

    @Override
    public boolean shouldCache() {
        return false;
    }

    @Override
    public boolean isCompatible(WorldProperties world) {
        return world.getDimensionType() != DimensionTypes.THE_END;
    }

    @Override
    public Object loadConfiguration(ConfigurationNode node, WorldProperties world, String preset) throws ObjectMappingException {
        Config cfg = (Config)node.getValue(Config.TOKEN);
        if (cfg == null) {
            cfg = new Config();
        }
        if (cfg.ground == null) {
            cfg.ground = Resources.of(world).getGround();
        }
        if (cfg.height < 0) {
            cfg.height = 0;
        }
        node.setValue(Config.TOKEN, (Object)cfg);
        return cfg.toImmutable();
    }

    @Override
    public void appendSignature(Signature.Builder builder, Object config) {
        Config.Immutable cfg = (Config.Immutable)config;
        builder.append((CatalogType)cfg.ground).append(cfg.height);
    }

    @Override
    public boolean isReady(ChunkView view, Object config) {
        return view.areNeighborsLoaded();
    }

    @Override
    public void modify(BlockView view, Vector3i min, Vector3i max, Random r, Object config) {
        Config.Immutable cfg = (Config.Immutable)config;
        int height = Math.min(max.getY(), cfg.height);
        if (height == 0) {
            return;
        }
        for (int x = min.getX(); x <= max.getX(); ++x) {
            for (int z = min.getZ(); z <= max.getZ(); ++z) {
                for (int y = height; y >= 0; --y) {
                    if (view.isExposed(x, y, z)) continue;
                    if (y <= r.nextInt(height)) {
                        view.setBlockType(x, y, z, BlockTypes.BEDROCK);
                        continue;
                    }
                    if (view.getBlockType(x, y, z) != BlockTypes.BEDROCK) continue;
                    view.setBlock(x, y, z, cfg.ground);
                }
            }
        }
    }

    @ConfigSerializable
    public static final class Config {
        public static final TypeToken<Config> TOKEN = TypeToken.of(Config.class);
        @Setting(value="Ground", comment="The ground type used to hide real bedrock")
        public BlockState ground;
        @Setting(value="Height", comment="The maximum layer where bedrock can be generated")
        public int height = 5;

        public Immutable toImmutable() {
            return new Immutable(this.ground, this.height);
        }

        public static final class Immutable {
            public final BlockState ground;
            public final int height;

            public Immutable(BlockState ground, int height) {
                this.ground = ground;
                this.height = height;
            }
        }
    }
}

