/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.modifier;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.api.cache.Signature;
import net.smoofyuniverse.mirage.api.modifier.ChunkModifier;
import net.smoofyuniverse.mirage.api.volume.BlockView;
import net.smoofyuniverse.mirage.api.volume.ChunkView;
import net.smoofyuniverse.mirage.resource.Resources;
import net.smoofyuniverse.mirage.util.MathUtil;
import net.smoofyuniverse.mirage.util.collection.BlockSet;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.world.storage.WorldProperties;

public class HideAllModifier
extends ChunkModifier {
    public HideAllModifier() {
        super(Mirage.get(), "HideAll");
    }

    @Override
    public Object loadConfiguration(ConfigurationNode node, WorldProperties world, String preset) throws ObjectMappingException {
        Config cfg = (Config)node.getValue(Config.TOKEN);
        if (cfg == null) {
            cfg = new Config();
        }
        if (preset.equals("water_dungeons")) {
            cfg.blocks = new BlockSet();
            cfg.blocks.add(BlockTypes.SEA_LANTERN);
            cfg.blocks.add(BlockTypes.PRISMARINE);
            cfg.blocks.add(BlockTypes.GOLD_BLOCK);
            cfg.replacement = BlockTypes.WATER.getDefaultState();
            cfg.minY = 30;
            cfg.maxY = 64;
        } else {
            if (cfg.blocks == null) {
                cfg.blocks = Resources.of(world).getBlocks("common", "rare");
            }
            if (cfg.replacement == null) {
                cfg.replacement = Resources.of(world).getGround();
            }
            cfg.minY = MathUtil.clamp(cfg.minY, 0, 255);
            cfg.maxY = MathUtil.clamp(cfg.maxY, 0, 255);
            if (cfg.minY > cfg.maxY) {
                int t = cfg.minY;
                cfg.minY = cfg.maxY;
                cfg.maxY = t;
            }
        }
        node.setValue(Config.TOKEN, (Object)cfg);
        return cfg.toImmutable();
    }

    @Override
    public void appendSignature(Signature.Builder builder, Object config) {
        Config.Immutable cfg = (Config.Immutable)config;
        builder.append(cfg.blocks).append((CatalogType)cfg.replacement).append(cfg.minY).append(cfg.maxY);
    }

    @Override
    public boolean isReady(ChunkView view, Object config) {
        return true;
    }

    @Override
    public void modify(BlockView view, Vector3i min, Vector3i max, Random r, Object config) {
        Config.Immutable cfg = (Config.Immutable)config;
        int maxX = max.getX();
        int maxY = Math.min(max.getY(), cfg.maxY);
        int maxZ = max.getZ();
        for (int y = Math.max(min.getY(), cfg.minY); y <= maxY; ++y) {
            for (int z = min.getZ(); z <= maxZ; ++z) {
                for (int x = min.getX(); x <= maxX; ++x) {
                    BlockState b = view.getBlock(x, y, z);
                    if (b.getType() == BlockTypes.AIR || b == cfg.replacement || !cfg.blocks.contains(b)) continue;
                    view.setBlock(x, y, z, cfg.replacement);
                }
            }
        }
    }

    @ConfigSerializable
    public static final class Config {
        public static final TypeToken<Config> TOKEN = TypeToken.of(Config.class);
        @Setting(value="Blocks", comment="Blocks that will be hidden by the modifier")
        public BlockSet blocks;
        @Setting(value="Replacement", comment="The block used to replace hidden blocks")
        public BlockState replacement;
        @Setting(value="MinY", comment="The minimum Y of the section to obfuscate")
        public int minY = 0;
        @Setting(value="MaxY", comment="The maximum Y of the section to obfuscate")
        public int maxY = 255;

        public Immutable toImmutable() {
            return new Immutable(this.blocks.getAll(), this.replacement, this.minY, this.maxY);
        }

        public static final class Immutable {
            public final Set<BlockState> blocks;
            public final BlockState replacement;
            public final int minY;
            public final int maxY;

            public Immutable(Collection<BlockState> blocks, BlockState replacement, int minY, int maxY) {
                this.blocks = ImmutableSet.copyOf(blocks);
                this.replacement = replacement;
                this.minY = minY;
                this.maxY = maxY;
            }
        }
    }
}

