/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.ore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.ore.adapter.InstantAdapter;
import net.smoofyuniverse.mirage.ore.object.DependencyInfo;
import net.smoofyuniverse.mirage.ore.object.VersionInfo;

public class OreAPI {
    public static final URL URL_BASE = OreAPI.getUrl();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new InstantAdapter()).create();

    private static URL getUrl() {
        try {
            return new URL("https://ore.spongepowered.org/api/v1/");
        }
        catch (MalformedURLException e) {
            Mirage.LOGGER.info("Failed to load object url", (Throwable)e);
            return null;
        }
    }

    public static List<VersionInfo> getProjectVersions(String projectId, String ... channels) throws Exception {
        return OreAPI.getProjectVersions(projectId, 0, 10, channels);
    }

    public static List<VersionInfo> getProjectVersions(String projectId, int offset, int limit, String ... channels) throws Exception {
        String suffix = "projects/" + projectId + "/versions?offset=" + offset + "&limit=" + limit;
        if (channels.length != 0) {
            suffix = suffix + "&channels=" + String.join((CharSequence)",", channels);
        }
        return (List)GSON.fromJson((Reader)new InputStreamReader(OreAPI.getUrl(suffix).openStream()), new TypeToken<List<VersionInfo>>(){}.getType());
    }

    public static URL getUrl(String suffix) throws MalformedURLException {
        return new URL(URL_BASE.getProtocol(), URL_BASE.getHost(), URL_BASE.getPort(), URL_BASE.getFile() + suffix);
    }

    public static Optional<String> getLatestVersion(List<VersionInfo> versions, VersionPredicate predicate) {
        String version = null;
        Instant date = null;
        for (VersionInfo info : versions) {
            if (date != null && !info.createdAt.isAfter(date)) continue;
            if (predicate != null) {
                int minor;
                int major;
                int i;
                String apiVersion = null;
                for (DependencyInfo d : info.dependencies) {
                    if (!d.pluginId.equals("spongeapi")) continue;
                    apiVersion = d.version;
                    break;
                }
                if (apiVersion == null || (i = apiVersion.indexOf(46)) == -1) continue;
                try {
                    major = Integer.parseInt(apiVersion.substring(0, i));
                }
                catch (NumberFormatException e) {
                    continue;
                }
                String temp = apiVersion.substring(i + 1);
                i = temp.indexOf(45);
                if (i != -1) {
                    temp = temp.substring(0, i);
                }
                if ((i = temp.indexOf(46)) != -1) {
                    temp = temp.substring(0, i);
                }
                try {
                    minor = Integer.parseInt(temp);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (!predicate.test(major, minor)) continue;
            }
            version = info.name;
            date = info.createdAt;
        }
        return Optional.ofNullable(version);
    }

    public static interface VersionPredicate {
        public boolean test(int var1, int var2);
    }
}

