/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.resource;

import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.resource.Pack;
import net.smoofyuniverse.mirage.util.IOUtil;
import net.smoofyuniverse.mirage.util.collection.BlockSet;
import org.spongepowered.api.GameRegistry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.storage.WorldProperties;

public final class Resources {
    private static final Map<DimensionType, Resources> map = new HashMap<DimensionType, Resources>();
    private final Map<String, BlockSet> blocks = new HashMap<String, BlockSet>();
    private BlockState ground;

    private Resources() {
    }

    public BlockState getGround() {
        return this.ground;
    }

    public BlockSet getBlocks(String category) {
        BlockSet set = this.blocks.get(category);
        return set == null ? new BlockSet() : set.copy();
    }

    public BlockSet getBlocks(String ... categories) {
        BlockSet col = null;
        for (String c : categories) {
            BlockSet set = this.blocks.get(c);
            if (set == null) continue;
            if (col == null) {
                col = set.copy();
                continue;
            }
            col.add(set);
        }
        return col == null ? new BlockSet() : col;
    }

    public void getBlocks(BlockSet col, String category) {
        BlockSet set = this.blocks.get(category);
        if (set != null) {
            col.add(set);
        }
    }

    public void getBlocks(BlockSet col, String ... categories) {
        for (String c : categories) {
            BlockSet set = this.blocks.get(c);
            if (set == null) continue;
            col.add(set);
        }
    }

    public static Resources of(WorldProperties world) {
        return Resources.of(world.getDimensionType());
    }

    public static Resources of(DimensionType type) {
        return map.get(type);
    }

    public static void loadResources() {
        Resources.loadResources(Resources.loadPacks());
    }

    public static void loadResources(TreeSet<Pack> packs) {
        map.clear();
        GameRegistry reg = Sponge.getRegistry();
        for (DimensionType type : reg.getAllOf(DimensionType.class)) {
            Mirage.LOGGER.info("Loading resources for dimension type: " + type.getId() + " ..");
            Resources r = new Resources();
            for (Pack p : packs) {
                Pack.Section s = p.getSection(type.getId()).orElse(null);
                if (s == null) continue;
                Mirage.LOGGER.debug("Loading resources from pack: " + p.name + " ..");
                for (Map.Entry e : s.groups.asMap().entrySet()) {
                    BlockSet set = r.blocks.get(e.getKey());
                    if (set == null) {
                        set = new BlockSet();
                        r.blocks.put((String)e.getKey(), set);
                    }
                    set.deserialize((Collection)e.getValue(), true);
                }
            }
            BlockSet set = r.blocks.get("ground");
            if (set != null) {
                r.ground = set.first().orElse(null);
            }
            if (r.ground == null) {
                r.ground = BlockTypes.STONE.getDefaultState();
                set = new BlockSet();
                set.add(r.ground);
                r.blocks.put("ground", set);
            }
            map.put(type, r);
        }
    }

    private static TreeSet<Pack> loadPacks() {
        TreeSet<Pack> packs = new TreeSet<Pack>();
        URL defaultUrl = IOUtil.getLocalResource("default.pack").orElse(null);
        if (defaultUrl != null) {
            Pack p = new Pack("default");
            Mirage.LOGGER.info("Reading default pack ..");
            try {
                p.read(defaultUrl);
                packs.add(p);
            }
            catch (Exception e) {
                Mirage.LOGGER.error("Failed to read default pack", (Throwable)e);
            }
        }
        PluginManager pm = Sponge.getPluginManager();
        try (DirectoryStream<Path> st = Files.newDirectoryStream(Mirage.get().getResourcesDirectory());){
            for (Path file : st) {
                String fn = file.getFileName().toString();
                if (!fn.endsWith(".pack")) continue;
                Pack p = new Pack(fn.substring(0, fn.length() - 5));
                Mirage.LOGGER.info("Reading pack: " + p.name + " ..");
                try {
                    p.read(file);
                    HashSet<String> missingMods = new HashSet<String>();
                    for (String id : p.required) {
                        if (pm.isLoaded(id)) continue;
                        missingMods.add(id);
                    }
                    if (!missingMods.isEmpty()) {
                        Mirage.LOGGER.info("The following mods are required to load this pack but are missing: [" + String.join((CharSequence)", ", missingMods) + "]");
                        continue;
                    }
                    packs.add(p);
                }
                catch (Exception e) {
                    Mirage.LOGGER.error("Failed to read pack: " + p.name, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Mirage.LOGGER.error("Failed to list packs", (Throwable)e);
        }
        return packs;
    }
}

