/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.util;

import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import net.smoofyuniverse.mirage.Mirage;

public class IOUtil {
    public static boolean backupFile(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            return false;
        }
        String fn = file.getFileName() + ".backup";
        Path backup = null;
        for (int i = 0; i < 100 && Files.exists(backup = file.resolveSibling(fn + i), new LinkOption[0]); ++i) {
        }
        Files.move(file, backup, new CopyOption[0]);
        return true;
    }

    public static Optional<URL> getLocalResource(String path) {
        return Optional.ofNullable(Mirage.class.getClassLoader().getResource(path));
    }
}

