/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.util.collection;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.smoofyuniverse.mirage.Mirage;
import org.spongepowered.api.GameRegistry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;

public final class BlockSet {
    public static final TypeToken<BlockSet> TOKEN = TypeToken.of(BlockSet.class);
    private final Set<BlockState> states = new LinkedHashSet<BlockState>();
    private final Set<BlockState> unmodState = Collections.unmodifiableSet(this.states);

    public Set<BlockState> getAll() {
        return this.unmodState;
    }

    public Optional<BlockState> first() {
        return this.states.isEmpty() ? Optional.empty() : Optional.of(this.states.iterator().next());
    }

    public void serialize(Collection<String> col, SerializationPredicate predicate) {
        for (Map.Entry<BlockType, List<BlockState>> e : this.asMap().entrySet()) {
            BlockType t = e.getKey();
            List<BlockState> l = e.getValue();
            if (predicate.mode(l.size(), t.getAllBlockStates().size())) {
                col.add(t.getId());
                for (BlockState b : t.getAllBlockStates()) {
                    if (l.contains(b)) continue;
                    col.add("-" + b.getId());
                }
                continue;
            }
            for (BlockState b : l) {
                col.add(b.getId());
            }
        }
    }

    public Map<BlockType, List<BlockState>> asMap() {
        LinkedHashMap<BlockType, List<BlockState>> map = new LinkedHashMap<BlockType, List<BlockState>>();
        for (BlockState state : this.states) {
            ArrayList<BlockState> set = (ArrayList<BlockState>)map.get(state.getType());
            if (set == null) {
                set = new ArrayList<BlockState>();
                map.put(state.getType(), set);
            }
            set.add(state);
        }
        return map;
    }

    public void deserialize(Collection<String> col, boolean skipErrors) {
        GameRegistry reg = Sponge.getRegistry();
        for (String id : col) {
            BlockType type;
            boolean value;
            boolean bl = value = id.charAt(0) != '-';
            if (!value) {
                id = id.substring(1);
            }
            if ((type = (BlockType)reg.getType(BlockType.class, id).orElse(null)) != null) {
                if (value) {
                    this.add(type);
                    continue;
                }
                this.remove(type);
                continue;
            }
            BlockState state = reg.getType(BlockState.class, id).orElse(null);
            if (state != null) {
                if (value) {
                    this.add(state);
                    continue;
                }
                this.remove(state);
                continue;
            }
            if (skipErrors) {
                Mirage.LOGGER.warn("Id '" + id + "' is not a valid BlockType or BlockState");
                continue;
            }
            throw new IllegalArgumentException("Id '" + id + "' is not a valid BlockType or BlockState");
        }
    }

    public void add(BlockType type) {
        this.states.addAll(type.getAllBlockStates());
    }

    public void remove(BlockType type) {
        this.states.removeAll(type.getAllBlockStates());
    }

    public void add(BlockState state) {
        this.states.add(state);
    }

    public void remove(BlockState state) {
        this.states.remove(state);
    }

    public int size() {
        return this.states.size();
    }

    public void clear() {
        this.states.clear();
    }

    public boolean contains(BlockState state) {
        return this.states.contains(state);
    }

    public void retain(BlockType type) {
        this.states.retainAll(type.getAllBlockStates());
    }

    public void add(BlockSet set) {
        this.states.addAll(set.states);
    }

    public void remove(BlockSet set) {
        this.states.removeAll(set.states);
    }

    public void retain(BlockSet set) {
        this.states.retainAll(set.states);
    }

    public BlockSet copy() {
        BlockSet set = new BlockSet();
        set.states.addAll(this.states);
        return set;
    }

    public static interface SerializationPredicate {
        public boolean mode(int var1, int var2);

        public static SerializationPredicate limit(float f) {
            return (states, max) -> (float)states / (float)max > f;
        }
    }
}

