/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.util.collection;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;

public final class WeightedList<T> {
    private final T[] objects;
    private final double[] weights;
    private final double total;
    private final int size;

    private WeightedList(T[] objects, double[] weights, double total) {
        this.objects = objects;
        this.weights = weights;
        this.total = total;
        this.size = objects.length;
    }

    public int getSize() {
        return this.size;
    }

    public T get(Random r) {
        int i = -1;
        for (double d = r.nextDouble() * this.total; d >= 0.0; d -= this.weights[++i]) {
        }
        return this.objects[i];
    }

    public void forEach(Consumer<T> c) {
        for (int i = 0; i < this.size; ++i) {
            c.accept(this.objects[i], this.weights[i]);
        }
    }

    public static <T> WeightedList<T> of(T[] objects, double[] weights) {
        if (objects.length != weights.length) {
            throw new IllegalArgumentException("Size");
        }
        if (objects.length == 0) {
            throw new IllegalArgumentException("Empty arrays");
        }
        ArrayList<Entry<T>> list = new ArrayList<Entry<T>>();
        for (int i = 0; i < objects.length; ++i) {
            list.add(new Entry<T>(objects[i], weights[i]));
        }
        return WeightedList.of(list);
    }

    public static <T> WeightedList<T> of(Iterable<Entry<T>> it) {
        ImmutableList list = ImmutableList.sortedCopyOf(it);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty iterator");
        }
        Object[] objects = new Object[list.size()];
        double[] weights = new double[list.size()];
        int i = 0;
        double total = 0.0;
        for (Entry e : list) {
            objects[i] = e.object;
            weights[i] = e.weight;
            total += e.weight;
            ++i;
        }
        return new WeightedList<Object>(objects, weights, total);
    }

    public static <T> WeightedList<T> of(Map<T, Double> map) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Empty map");
        }
        ArrayList<Entry<T>> list = new ArrayList<Entry<T>>();
        for (Map.Entry<T, Double> e : map.entrySet()) {
            list.add(new Entry<T>(e.getKey(), e.getValue()));
        }
        return WeightedList.of(list);
    }

    public static final class Entry<T>
    implements Comparable<Entry<T>> {
        public final T object;
        public final double weight;

        public Entry(T object, double weight) {
            if (Double.isNaN(weight) || weight <= 0.0) {
                throw new IllegalArgumentException("Weight");
            }
            this.object = object;
            this.weight = weight;
        }

        @Override
        public int compareTo(Entry<T> o) {
            return Double.compare(o.weight, this.weight);
        }
    }

    public static interface Consumer<T> {
        public void accept(T var1, double var2);
    }
}

