/*
 * Decompiled with CFR 0.152.
 */
package fr.rhaz.sponge.commandsigns;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import fr.rhaz.sponge.commandsigns.Clipboard;
import fr.rhaz.sponge.commandsigns.Message;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.TileEntityTypes;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.TypeTokens;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Plugin(id="commandsigns", name="CommandSigns Reloaded", version="2.10")
public class CommandSigns {
    private ConfigurationNode config;
    private static CommandSigns i;
    private EventContext context;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDir;
    @Inject
    @ConfigDir(sharedRoot=true)
    private Path mainDir;
    private HoconConfigurationLoader cloader;
    public static Map<UUID, Clipboard> clipboards;
    public static Set<UUID> unsafe;
    public EconomyService eco = null;

    static {
        clipboards = new HashMap<UUID, Clipboard>();
        unsafe = new HashSet<UUID>();
    }

    @Listener
    public void onServerStart(GameStartedServerEvent e) {
        i = this;
        this.context = EventContext.builder().add(EventContextKeys.PLUGIN, (Object)i.getContainer()).build();
        this.loadConfig();
        CommandSpec.Builder cmdMain = CommandSpec.builder().description((Text)Text.of((String)"CommandSigns")).permission("csigns.version").executor(new CommandExecutor(){

            public CommandResult execute(CommandSource src, CommandContext ctx) throws CommandException {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.BLUE, "[CommandSigns]: ", TextColors.GRAY, "Version: ", TextColors.GOLD, CommandSigns.this.getContainer().getVersion().get()}));
                return CommandResult.success();
            }
        });
        CommandSpec.Builder cmdAdd = CommandSpec.builder().description((Text)Text.of((String)"Add a command to a sign")).permission("csigns.add").arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.remainingJoinedStrings((Text)Text.of((String)"command")))).executor(new CommandExecutor(){

            public CommandResult execute(CommandSource src, CommandContext ctx) throws CommandException {
                try {
                    if (!(src instanceof Player)) {
                        throw new Message(TextColors.DARK_RED, "Error! ", TextColors.RED, "Must be an in-game player!");
                    }
                    Player player = (Player)src;
                    String command = (String)ctx.getOne("command").get();
                    boolean error = false;
                    if (command.startsWith("error ")) {
                        command = command.substring("error ".length());
                        error = true;
                    }
                    clipboards.put(player.getUniqueId(), new Clipboard("add").key(error ? "error" : "normal").value(command));
                    throw new Message(TextColors.DARK_RED, "[CommandSigns]: ", TextColors.GOLD, "Right click a sign!");
                }
                catch (Message msg) {
                    src.sendMessage(msg.text());
                    return CommandResult.success();
                }
            }
        });
        cmdMain.child((CommandCallable)cmdAdd.build(), new String[]{"add"});
        CommandSpec.Builder cmdList = CommandSpec.builder().description((Text)Text.of((String)"List commands of a sign")).permission("csigns.list").arguments(GenericArguments.optional((CommandElement)GenericArguments.remainingJoinedStrings((Text)Text.of((String)"error")))).executor(new CommandExecutor(){

            public CommandResult execute(CommandSource src, CommandContext ctx) throws CommandException {
                try {
                    if (!(src instanceof Player)) {
                        throw new Message(TextColors.DARK_RED, "Error! ", TextColors.RED, "Must be an in-game player!");
                    }
                    Player player = (Player)src;
                    boolean error = false;
                    Optional arg = ctx.getOne("error");
                    if (arg.isPresent() && ((String)arg.get()).equals("error")) {
                        error = true;
                    }
                    clipboards.put(player.getUniqueId(), new Clipboard("list").key(error ? "error" : "normal"));
                    throw new Message(TextColors.DARK_RED, "[CommandSigns]: ", TextColors.GOLD, "Right click a sign!");
                }
                catch (Message msg) {
                    src.sendMessage(msg.text());
                    return CommandResult.success();
                }
            }
        });
        cmdMain.child((CommandCallable)cmdList.build(), new String[]{"list"});
        CommandSpec.Builder cmdUnsafe = CommandSpec.builder().description((Text)Text.of((String)"Toggle unsafe mode")).permission("csigns.unsafe").executor(new CommandExecutor(){

            public CommandResult execute(CommandSource src, CommandContext ctx) throws CommandException {
                try {
                    if (!(src instanceof Player)) {
                        throw new Message(TextColors.DARK_RED, "Error! ", TextColors.RED, "Must be an in-game player!");
                    }
                    Player player = (Player)src;
                    UUID uuid = player.getUniqueId();
                    if (unsafe.contains(uuid)) {
                        unsafe.remove(uuid);
                        throw new Message(TextColors.DARK_RED, "[CommandSigns]: ", TextColors.GOLD, "Unsafe mode disabled");
                    }
                    unsafe.add(uuid);
                    throw new Message(TextColors.DARK_RED, "[CommandSigns]: ", TextColors.GOLD, "Unsafe mode enabled");
                }
                catch (Message msg) {
                    src.sendMessage(msg.text());
                    return CommandResult.success();
                }
            }
        });
        cmdMain.child((CommandCallable)cmdUnsafe.build(), new String[]{"unsafe"});
        CommandSpec.Builder cmdClear = CommandSpec.builder().description((Text)Text.of((String)"Clear uses of a sign")).permission("csigns.clear").executor(new CommandExecutor(){

            public CommandResult execute(CommandSource src, CommandContext ctx) throws CommandException {
                try {
                    if (!(src instanceof Player)) {
                        throw new Message(TextColors.DARK_RED, "Error! ", TextColors.RED, "Must be an in-game player!");
                    }
                    Player player = (Player)src;
                    clipboards.put(player.getUniqueId(), new Clipboard("clear"));
                    throw new Message(TextColors.DARK_RED, "[CommandSigns]: ", TextColors.GOLD, "Right click a sign!");
                }
                catch (Message msg) {
                    src.sendMessage(msg.text());
                    return CommandResult.success();
                }
            }
        });
        cmdMain.child((CommandCallable)cmdClear.build(), new String[]{"clear"});
        CommandSpec.Builder cmdSet = CommandSpec.builder().description((Text)Text.of((String)"Set options of a sign")).permission("csigns.set").arguments(GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.string((Text)Text.of((String)"option")), GenericArguments.string((Text)Text.of((String)"value"))})).executor(new CommandExecutor(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public CommandResult execute(CommandSource src, CommandContext ctx) throws CommandException {
                try {
                    if (!(src instanceof Player)) {
                        throw new Message(TextColors.DARK_RED, "Error! ", TextColors.RED, "Must be an in-game player!");
                    }
                    Player player = (Player)src;
                    String option = ((String)ctx.getOne("option").get()).toLowerCase();
                    String value = ((String)ctx.getOne("value").get()).toLowerCase();
                    Clipboard cb = new Clipboard("set");
                    if (!Arrays.asList("onetime", "permission", "cooldown", "redstonable", "price", "redstoning").contains(option)) {
                        throw new Message(TextColors.DARK_RED, "Error! ", TextColors.RED, "Unknown option '" + option + "'");
                    }
                    if (Arrays.asList("onetime", "redstonable", "redstoning").contains(option)) {
                        if (!Arrays.asList("true", "false").contains(value)) throw new Message(TextColors.DARK_RED, "Error! ", TextColors.RED, "The option '" + option + "' must be 'true' or 'false'.");
                        cb.key(option).value(value.equals("true"));
                    } else if (Arrays.asList("cooldown", "price").contains(option)) {
                        try {
                            cb.key(option).value(Integer.valueOf(value));
                        }
                        catch (NumberFormatException ex) {
                            throw new Message(TextColors.DARK_RED, "Error! ", TextColors.RED, "The option '" + option + "' must be a number.");
                        }
                    } else {
                        cb.key(option).value(value);
                    }
                    clipboards.put(player.getUniqueId(), cb);
                    throw new Message(TextColors.DARK_RED, "[CommandSigns]: ", TextColors.GOLD, "Right click a sign!");
                }
                catch (Message msg) {
                    src.sendMessage(msg.text());
                    return CommandResult.success();
                }
            }
        });
        cmdMain.child((CommandCallable)cmdSet.build(), new String[]{"set"});
        CommandSpec.Builder cmdRemove = CommandSpec.builder().description((Text)Text.of((String)"Remove a command of a sign")).permission("csigns.remove").arguments(new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.string((Text)Text.of((String)"error"))), GenericArguments.integer((Text)Text.of((String)"index"))}).executor(new CommandExecutor(){

            public CommandResult execute(CommandSource src, CommandContext ctx) throws CommandException {
                try {
                    int index;
                    if (!(src instanceof Player)) {
                        throw new Message(TextColors.DARK_RED, "Error! ", TextColors.RED, "Must be an in-game player!");
                    }
                    Player player = (Player)src;
                    boolean error = false;
                    Optional err = ctx.getOne("error");
                    if (err.isPresent() && ((String)err.get()).equals("error")) {
                        error = true;
                    }
                    if ((index = ((Integer)ctx.getOne("index").get()).intValue()) < 1) {
                        throw new Message(TextColors.DARK_RED, "Error! ", TextColors.RED, "You must provide a number higher than 0.");
                    }
                    clipboards.put(player.getUniqueId(), new Clipboard("remove").key(error ? "error" : "normal").value(index));
                    throw new Message(TextColors.DARK_RED, "[CommandSigns]: ", TextColors.GOLD, "Right click a sign!");
                }
                catch (Message msg) {
                    src.sendMessage(msg.text());
                    return CommandResult.success();
                }
            }
        });
        cmdMain.child((CommandCallable)cmdRemove.build(), new String[]{"remove"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)cmdMain.build(), new String[]{"cs", "csign", "csigns", "commandsign", "commandsigns"});
        Optional economy = Sponge.getServiceManager().provide(EconomyService.class);
        if (economy.isPresent()) {
            this.eco = (EconomyService)economy.get();
        }
    }

    public static Logger getLogger() {
        return i.getContainer().getLogger();
    }

    public ConfigurationNode loadConfig() {
        try {
            String name = "config.conf";
            URL def = ((Asset)this.getContainer().getAsset(name).get()).getUrl();
            HoconConfigurationLoader defloader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setURL(def)).build();
            ConfigurationNode defaults = defloader.load();
            File cfile = new File(this.configDir.toFile(), name);
            if (!this.configDir.toFile().exists()) {
                this.configDir.toFile().mkdirs();
            }
            if (!cfile.exists()) {
                cfile.createNewFile();
            }
            this.cloader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(cfile)).build();
            this.config = this.cloader.load();
            this.config.mergeValuesFrom(defaults);
            this.cloader.save(this.config);
            return this.config;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveConfig() {
        try {
            this.cloader.save(this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CommandSigns get() {
        return i;
    }

    public PluginContainer getContainer() {
        return (PluginContainer)Sponge.getPluginManager().fromInstance((Object)i).get();
    }

    public EventContext getContext() {
        return this.context;
    }

    public List<String> getStringList(ConfigurationNode node) {
        try {
            return node.getList(TypeTokens.STRING_TOKEN, new ArrayList());
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public void clear(ConfigurationNode node) {
        node.setValue(null);
        if (node.getParent().getChildrenMap().isEmpty()) {
            node.getParent().setValue(null);
        }
        if (node.getParent().getParent().getChildrenMap().isEmpty()) {
            node.getParent().getParent().setValue(null);
        }
    }

    @Listener
    public void onRedstone(NotifyNeighborBlockEvent event, @First LocatableBlock source) {
        Location location = source.getLocation();
        ConfigurationNode node = this.config.getNode(new Object[]{"signs", ((World)location.getExtent()).getName(), String.valueOf(location.getBlockX()), String.valueOf(location.getBlockY()), String.valueOf(location.getBlockZ())});
        if (node.isVirtual()) {
            return;
        }
        boolean redstonable = node.getNode(new Object[]{"redstonable"}).getBoolean(false);
        if (!redstonable) {
            return;
        }
        List<Location<World>> locations = CommandSigns.getAdjacents((Location<World>)location);
        locations.add((Location<World>)location);
        Optional<Integer> opower = CommandSigns.getDirectBlockPowerLevel(locations);
        boolean last = node.getNode(new Object[]{"powered"}).getBoolean(false);
        if (!opower.isPresent()) {
            return;
        }
        Integer power = opower.get();
        boolean powered = power > 0;
        node.getNode(new Object[]{"powered"}).setValue((Object)powered);
        this.saveConfig();
        if (powered == last) {
            return;
        }
        if (!powered) {
            return;
        }
        final List<String> commands = this.getStringList(node.getNode(new Object[]{"commands"}));
        if (commands.isEmpty()) {
            return;
        }
        Player player = null;
        for (Entity target : ((World)location.getExtent()).getNearbyEntities(location.getPosition(), 10.0)) {
            if (!(target instanceof Player)) continue;
            player = (Player)target;
            break;
        }
        if (player == null) {
            return;
        }
        Player fplayer = player;
        Task.builder().async().execute(new Runnable((CommandSource)fplayer){
            private final /* synthetic */ CommandSource val$fplayer;
            {
                this.val$fplayer = commandSource;
            }

            @Override
            public void run() {
                for (String command : commands) {
                    Object csource = null;
                    String[] split = command.split(":");
                    if (split.length > 1) {
                        String name = split[0];
                        command = command.substring("console:".length());
                        csource = split[0].equalsIgnoreCase("console") ? Sponge.getServer().getConsole() : (CommandSource)Sponge.getServer().getPlayer(name).orElse(null);
                    }
                    if (csource == null && (csource = this.val$fplayer) == null) continue;
                    command = command.replaceAll("@p", this.val$fplayer.getName());
                    final CommandSource fsource = csource;
                    final String fcommand = command;
                    if (!command.startsWith("wait ")) {
                        Task.builder().execute(new Runnable(){

                            @Override
                            public void run() {
                                Sponge.getCommandManager().process(fsource, fcommand);
                            }
                        }).submit((Object)i);
                        continue;
                    }
                    try {
                        Long delay = Long.decode(command.substring("wait ".length()));
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException | NumberFormatException exception) {
                        // empty catch block
                    }
                }
            }
        }).submit((Object)i);
        boolean redstoning = node.getNode(new Object[]{"redstoning"}).getBoolean(false);
        if (redstoning) {
            this.setRedstoneBlock((Location<World>)location);
        }
    }

    public static Optional<Integer> getDirectBlockPowerLevel(List<Location<World>> locations) {
        int power = -1;
        for (Location<World> block : locations) {
            Optional<Integer> optional = CommandSigns.getDirectBlockPowerLevel(block);
            if (!optional.isPresent() || power >= optional.get()) continue;
            power = optional.get();
        }
        return power == -1 ? Optional.empty() : Optional.of(power);
    }

    public static Optional<Integer> getDirectBlockPowerLevel(Location<World> block) {
        if (block.get(Keys.POWER).isPresent()) {
            return block.get(Keys.POWER);
        }
        if (block.get(Keys.POWERED).isPresent()) {
            return block.get(Keys.POWERED).map(powered -> powered != false ? 15 : 0);
        }
        if (block.getBlock().getType() == BlockTypes.POWERED_REPEATER || block.getBlock().getType() == BlockTypes.UNPOWERED_REPEATER) {
            return Optional.of(block.getBlock().getType() == BlockTypes.POWERED_REPEATER ? 15 : 0);
        }
        return Optional.empty();
    }

    public void setRedstoneBlock(Location<World> location) {
        BlockState state = (BlockState)location.getBlock().copy();
        location.setBlockType(BlockTypes.REDSTONE_BLOCK);
        Task.builder().delayTicks(1L).execute(() -> location.setBlock(state)).submit((Object)i);
    }

    public static List<Location<World>> getAdjacents(Location<World> location) {
        Direction[] faces;
        ArrayList<Location<World>> locations = new ArrayList<Location<World>>();
        Direction[] directionArray = faces = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        int n = faces.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            locations.add((Location<World>)location.getRelative(direction));
            ++n2;
        }
        return locations;
    }

    @Listener
    public void onPlayerHitBlock(InteractBlockEvent.Primary event, @First Player player) {
        if (!event.getTargetBlock().getLocation().isPresent()) {
            return;
        }
        Location location = (Location)event.getTargetBlock().getLocation().get();
        ConfigurationNode node = this.config.getNode(new Object[]{"signs", ((World)location.getExtent()).getName(), String.valueOf(location.getBlockX()), String.valueOf(location.getBlockY()), String.valueOf(location.getBlockZ())});
        if (node.isVirtual()) {
            return;
        }
        if (player.hasPermission("csigns.destroy")) {
            this.clear(node);
            this.saveConfig();
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.GRAY, "Successfully removed CommandSign!"}));
        } else {
            event.setCancelled(true);
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.DARK_RED, "Error! ", TextColors.RED, "You do not have permission to break CommandSigns!"}));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Listener
    public void onPlayerInteractBlock(InteractBlockEvent.Secondary event, final @First Player player) {
        block45: {
            if (!event.getTargetBlock().getLocation().isPresent()) {
                return;
            }
            if (!event.getHandType().equals(HandTypes.MAIN_HAND)) {
                return;
            }
            location = (Location)event.getTargetBlock().getLocation().get();
            node = this.config.getNode(new Object[]{"signs", ((World)location.getExtent()).getName(), String.valueOf(location.getBlockX()), String.valueOf(location.getBlockY()), String.valueOf(location.getBlockZ())});
            cb = CommandSigns.clipboards.remove(player.getUniqueId());
            silent = this.config.getNode(new Object[]{"silent"}).getBoolean(false);
            try {
                if (cb == null) {
                    if (node.isVirtual()) {
                        return;
                    }
                    nopermission = new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.RED, "You do not have permission to use this sign."});
                    err = new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.RED, "An internal error occured."});
                    if (!player.hasPermission("csigns.use")) {
                        if (!silent) {
                            throw nopermission;
                        }
                        return;
                    }
                    permission = node.getNode(new Object[]{"permission"}).getString("");
                    if (!Strings.isNullOrEmpty((String)permission) && !player.hasPermission(permission)) {
                        if (!silent) {
                            throw nopermission;
                        }
                        return;
                    }
                    commands = this.getStringList(node.getNode(new Object[]{"commands"}));
                    onetime = node.getNode(new Object[]{"onetime"}).getBoolean(false);
                    cooldown = node.getNode(new Object[]{"cooldown"}).getInt(0);
                    price = node.getNode(new Object[]{"price"}).getDouble(0.0);
                    redstoning = node.getNode(new Object[]{"redstoning"}).getBoolean(false);
                    if (price > 0.0) {
                        if (this.eco == null) {
                            CommandSigns.getLogger().warn("No economy service found!");
                            throw err;
                        }
                        optacc = this.eco.getOrCreateAccount(player.getUniqueId());
                        if (!optacc.isPresent()) {
                            throw err;
                        }
                        acc = (UniqueAccount)optacc.get();
                        curr = this.eco.getDefaultCurrency();
                        val = BigDecimal.valueOf(price);
                        nomoney = new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.RED, "You do not have enough money."});
                        if (!acc.hasBalance(curr)) {
                            throw nomoney;
                        }
                        if (acc.getBalance(curr).compareTo(val) == -1) {
                            throw nomoney;
                        }
                        acc.withdraw(curr, val, Cause.of((EventContext)this.getContext(), (Object)this.getContainer()));
                    }
                    if (onetime || cooldown > 0) {
                        user = node.getNode(new Object[]{"users", player.getUniqueId().toString()});
                        format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.ENGLISH);
                        now = new Date();
                        if (!user.isVirtual()) {
                            try {
                                last = format.parse(user.getString());
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                                throw err;
                            }
                            diff = (now.getTime() - last.getTime()) / 1000L - 43200L;
                            if (onetime) {
                                if (!silent) {
                                    throw new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.RED, "You have already used this sign."});
                                }
                                return;
                            }
                            if (diff < (long)cooldown) {
                                if (!silent) {
                                    throw new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.RED, "You have already used this sign recently."});
                                }
                                return;
                            }
                        }
                        date = format.format(now);
                        user.setValue((Object)date);
                        this.saveConfig();
                    }
                    if (commands.isEmpty()) {
                        throw new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.RED, "No commands are set on this CommandSign."});
                    }
                    if (!silent) {
                        player.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.GRAY, "Executing commands."}));
                    }
                    Task.builder().async().execute(new Runnable(){

                        @Override
                        public void run() {
                            for (String command : commands) {
                                Object source = player;
                                String[] split = command.split(":");
                                if (split.length > 1) {
                                    String name = split[0];
                                    command = command.substring("console:".length());
                                    source = split[0].equalsIgnoreCase("console") ? Sponge.getServer().getConsole() : (CommandSource)Sponge.getServer().getPlayer(name).orElse(null);
                                }
                                if (source == null) continue;
                                command = command.replaceAll("@p", player.getName());
                                Player fsource = source;
                                String fcommand = command;
                                if (!command.startsWith("wait ")) {
                                    Task.builder().execute(new Runnable((CommandSource)fsource, fcommand){
                                        private final /* synthetic */ CommandSource val$fsource;
                                        private final /* synthetic */ String val$fcommand;
                                        {
                                            this.val$fsource = commandSource;
                                            this.val$fcommand = string;
                                        }

                                        @Override
                                        public void run() {
                                            Sponge.getCommandManager().process(this.val$fsource, this.val$fcommand);
                                        }
                                    }).submit((Object)i);
                                    continue;
                                }
                                try {
                                    Long delay = Long.decode(command.substring("wait ".length()));
                                    Thread.sleep(delay);
                                }
                                catch (InterruptedException | NumberFormatException exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }).submit((Object)CommandSigns.i);
                    if (redstoning) {
                        this.setRedstoneBlock((Location<World>)location);
                    }
                    return;
                }
                if (node.isVirtual()) {
                    if (!Arrays.asList(new String[]{"add", "set"}).contains(cb.getAction())) {
                        throw new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.RED, "This sign is not a CommandSign."});
                    }
                    if (!player.hasPermission("csigns.create")) {
                        throw new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.RED, "You do not have permission to create a new sign."});
                    }
                    if (!CommandSigns.unsafe.contains(player.getUniqueId())) {
                        notasign = new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.RED, "This is not a sign. Use '/cs unsafe' to allow other blocks."});
                        if (!location.getTileEntity().isPresent()) {
                            throw notasign;
                        }
                        tile = (TileEntity)location.getTileEntity().get();
                        if (!tile.getType().equals(TileEntityTypes.SIGN)) {
                            throw notasign;
                        }
                    }
                    if (cb.getAction().equals("add")) {
                        error = cb.getKey().equals("error");
                        cnode = node.getNode(new Object[]{error != false ? "error" : "commands"});
                        commands = this.getStringList(cnode);
                        commands.add((String)cb.getValue());
                        cnode.setValue(commands);
                    }
                    if (cb.getAction().equals("set")) {
                        node.getNode(new Object[]{cb.getKey()}).setValue(cb.getValue());
                    }
                    this.saveConfig();
                    throw new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.GRAY, "This sign is now a CommandSign."});
                }
                if (cb.getAction().equals("list")) {
                    error = cb.getKey().equals("error");
                    cnode = node.getNode(new Object[]{error != false ? "error" : "commands"});
                    commands = this.getStringList(cnode);
                    paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
                    msgs = new ArrayList<Text>();
                    i = 0;
                    for (String cmd : commands) {
                        msgs.add(Text.of((Object[])new Object[]{TextColors.WHITE, String.valueOf(++i) + ") ", TextColors.GOLD, cmd}));
                    }
                    paginationBuilder = paginationService.builder().contents(msgs).title(Text.of((Object[])new Object[]{TextColors.GREEN, "Showing " + (error != false ? "Error " : "") + "Commands"})).padding((Text)Text.of((String)"-"));
                    paginationBuilder.sendTo((MessageReceiver)player);
                    return;
                }
                if (cb.getAction().equals("add")) {
                    error = cb.getKey().equals("error");
                    cnode = node.getNode(new Object[]{error != false ? "error" : "commands"});
                    commands = this.getStringList(cnode);
                    commands.add((String)cb.getValue());
                    cnode.setValue(commands);
                    this.saveConfig();
                    throw new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.GRAY, "Added " + (error != false ? "error " : "") + "command #" + commands.size() + " to this sign."});
                }
                if (cb.getAction().equals("remove")) {
                    error = cb.getKey().equals("error");
                    cnode = node.getNode(new Object[]{error != false ? "error" : "commands"});
                    commands = this.getStringList(cnode);
                    index = (Integer)cb.getValue();
                    if (commands.size() < index) {
                        throw new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.RED, "This index does not correspond to " + (error != false ? "an error " : "a ") + "command on this sign."});
                    }
                    commands.remove(index - 1);
                    cnode.setValue(commands);
                    this.saveConfig();
                    throw new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.GRAY, "Removed " + (error != false ? "error " : "") + "command #" + index + " from this sign."});
                }
                if (cb.getAction().equals("clear")) {
                    node.getNode(new Object[]{"users"}).setValue(null);
                    this.saveConfig();
                    throw new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.GRAY, "Cleared all users of this sign."});
                }
                if (cb.getAction().equals("set")) {
                    if (cb.getAction().equals("set")) {
                        node.getNode(new Object[]{cb.getKey()}).setValue(cb.getValue());
                    }
                    this.saveConfig();
                    throw new Message(new Object[]{TextColors.GOLD, "[CommandSigns]: ", TextColors.GRAY, "Option '" + cb.getKey() + "' set to '" + cb.getValue() + "'"});
                }
                break block45;
            }
            catch (Message msg) {
                err = this.getStringList(node.getNode(new Object[]{"error"}));
                if (cb != null || err.isEmpty()) {
                    player.sendMessage(msg.text());
                    break block45;
                }
                ** for (command : err)
            }
lbl-1000:
            // 1 sources

            {
                source = player;
                if (command.startsWith("console:")) {
                    command = command.substring("console:".length());
                    source = Sponge.getServer().getConsole();
                }
                command = command.replaceAll("@p", player.getName());
                Sponge.getCommandManager().process((CommandSource)source, command);
                continue;
            }
        }
    }
}

