/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wft.client.gui;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.me.FluidRepo;
import appeng.client.me.InternalFluidSlotME;
import appeng.client.me.SlotFluidME;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.fluids.container.slots.IMEFluidSlot;
import appeng.helpers.InventoryAction;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.lwjgl.input.Mouse;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.client.FluidStackSizeRenderer;
import p455w0rd.ae2wtlib.api.client.IWTGuiScrollbar;
import p455w0rd.ae2wtlib.api.client.ReadableNumberConverter;
import p455w0rd.ae2wtlib.api.client.gui.GuiWT;
import p455w0rd.ae2wtlib.api.client.gui.widgets.GuiImgButtonBooster;
import p455w0rd.ae2wtlib.api.client.gui.widgets.GuiMETextField;
import p455w0rd.ae2wtlib.api.client.gui.widgets.GuiScrollbar;
import p455w0rd.wft.container.ContainerWFT;
import p455w0rd.wft.init.ModNetworking;
import p455w0rd.wft.sync.packets.PacketInventoryAction;
import p455w0rd.wft.sync.packets.PacketValueConfig;
import p455w0rd.wft.util.WFTUtils;
import yalter.mousetweaks.api.MouseTweaksIgnore;

@MouseTweaksIgnore
public class GuiWFT
extends GuiWT
implements ISortSource,
IConfigManagerHost {
    private final List<SlotFluidME> meFluidSlots = new LinkedList<SlotFluidME>();
    private final FluidRepo repo;
    private final IConfigManager configSrc;
    private final ContainerWFT container;
    private final int rows = 5;
    protected ITerminalHost terminal;
    private GuiMETextField searchField;
    private GuiImgButton sortByBox;
    private GuiImgButton sortDirBox;
    private GuiImgButtonBooster autoConsumeBoostersBox;

    public GuiWFT(Container container) {
        super(container);
        this.field_146999_f = 185;
        this.field_147000_g = 222;
        this.terminal = ((ContainerWFT)container).getGuiObject();
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar((IWTGuiScrollbar)scrollbar);
        this.repo = new FluidRepo((IScrollSource)scrollbar, (ISortSource)this);
        this.configSrc = ((IConfigurableObject)this.field_147002_h).getConfigManager();
        this.container = (ContainerWFT)this.field_147002_h;
        this.container.setGui(this);
    }

    public void func_73866_w_() {
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.searchField = new GuiMETextField(this.field_146289_q, this.field_147003_i + Math.max(79, 8), this.field_147009_r + 4, 90, 12);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.setSelectionColor(-6684775);
        this.searchField.func_146189_e(true);
        super.func_73866_w_();
        this.sortByBox = new GuiImgButton(this.getButtonPanelXOffset(), this.getButtonPanelYOffset(), (Enum)Settings.SORT_BY, this.configSrc.getSetting(Settings.SORT_BY));
        this.getButtonPanel().addButton((GuiButton)this.sortByBox);
        this.sortDirBox = new GuiImgButton(this.getButtonPanelXOffset(), this.getButtonPanelYOffset(), (Enum)Settings.SORT_DIRECTION, this.configSrc.getSetting(Settings.SORT_DIRECTION));
        this.getButtonPanel().addButton((GuiButton)this.sortDirBox);
        if (!WTApi.instance().getConfig().isOldInfinityMechanicEnabled() && !WTApi.instance().isWTCreative(this.getWirelessTerminal())) {
            this.autoConsumeBoostersBox = new GuiImgButtonBooster(this.getButtonPanelXOffset(), this.getButtonPanelYOffset(), this.container.getWirelessTerminal());
            this.getButtonPanel().addButton((GuiButton)this.autoConsumeBoostersBox);
        }
        this.getButtonPanel().init((GuiWT)this);
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 9; ++x) {
                SlotFluidME slot = new SlotFluidME(new InternalFluidSlotME(this.repo, x + y * 9, 8 + x * 18, 18 + y * 18));
                this.getMeFluidSlots().add(slot);
                this.field_147002_h.field_75151_b.add(slot);
            }
        }
        this.setScrollBar();
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName("Fluid Terminal"), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 100, 0x404040);
        String warning = "";
        if (WTApi.instance().getConfig().isInfinityBoosterCardEnabled() && !WTApi.instance().getConfig().isOldInfinityMechanicEnabled()) {
            int infinityEnergyAmount = WTApi.instance().getInfinityEnergy(this.container.getWirelessTerminal());
            if (WTApi.instance().hasInfiniteRange(this.getWirelessTerminal()) && !WTApi.instance().isInRangeOfWAP(this.getWirelessTerminal(), WFTUtils.player()) && infinityEnergyAmount < WTApi.instance().getConfig().getLowInfinityEnergyWarningAmount()) {
                warning = TextFormatting.RED + "" + I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().infinityEnergyLow(), (Object[])new Object[0]);
            }
            if (!WTApi.instance().isWTCreative(this.getWirelessTerminal()) && this.func_146978_c(this.container.getBoosterSlot().field_75223_e, this.container.getBoosterSlot().field_75221_f, 16, 16, mouseX, mouseY) && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                String amountColor = infinityEnergyAmount < WTApi.instance().getConfig().getLowInfinityEnergyWarningAmount() ? TextFormatting.RED.toString() : TextFormatting.GREEN.toString();
                String infinityEnergy = I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().infinityEnergy(), (Object[])new Object[0]) + ": " + amountColor + "" + (GuiWFT.func_146272_n() ? Integer.valueOf(infinityEnergyAmount) : ReadableNumberConverter.INSTANCE.toSlimReadableForm((long)infinityEnergyAmount)) + "" + TextFormatting.GRAY + " " + I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().units(), (Object[])new Object[0]);
                this.drawTooltip(mouseX - offsetX, mouseY - offsetY, infinityEnergy);
            }
        }
        this.field_146297_k.field_71466_p.func_78276_b(warning, 8, this.field_147000_g - 111, 0x404040);
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        ResourceLocation loc = new ResourceLocation("wft", "textures/" + this.getBackground());
        this.field_146297_k.func_110434_K().func_110577_a(loc);
        int x_width = 197;
        this.func_73729_b(offsetX, offsetY, 0, 0, 197, 18);
        for (int x = 0; x < 5; ++x) {
            this.func_73729_b(offsetX, offsetY + 18 + x * 18, 0, 18, 197, 18);
        }
        this.func_73729_b(offsetX, offsetY + 16 + 108 - 18, 0, 70, 197, 8);
        this.func_73729_b(offsetX, offsetY + 16 + 108 - 10, 0, 78, 197, 7);
        this.func_73729_b(offsetX, offsetY + 16 + 108 - 3, 0, 78, 197, 7);
        this.func_73729_b(offsetX, offsetY + 16 + 108, 0, 78, 197, 176);
        if (WTApi.instance().getConfig().isInfinityBoosterCardEnabled() && !WTApi.instance().isWTCreative(this.getWirelessTerminal())) {
            this.func_73729_b(this.field_147003_i + 150, this.field_147009_r + 90 + 18, 237, 237, 19, 19);
        }
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
    }

    public void func_146977_a(Slot s) {
        if (s instanceof IMEFluidSlot && ((IMEFluidSlot)s).shouldRenderAsFluid()) {
            IMEFluidSlot slot = (IMEFluidSlot)s;
            IAEFluidStack fs = slot.getAEFluidStack();
            if (fs != null && this.isPowered()) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179084_k();
                Fluid fluid = fs.getFluid();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill().toString());
                float red = (float)(fluid.getColor() >> 16 & 0xFF) / 255.0f;
                float green = (float)(fluid.getColor() >> 8 & 0xFF) / 255.0f;
                float blue = (float)(fluid.getColor() & 0xFF) / 255.0f;
                GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
                this.func_175175_a(s.field_75223_e, s.field_75221_f, sprite, 16, 16);
                GlStateManager.func_179145_e();
                GlStateManager.func_179147_l();
                FluidStackSizeRenderer.getInstance().renderStackSize(this.field_146289_q, fs, s.field_75223_e, s.field_75221_f);
            }
            return;
        }
        super.func_146977_a(s);
    }

    public void func_73876_c() {
        this.repo.setPower(this.container.isPowered());
        super.func_73876_c();
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        IMEFluidSlot fluidSlot;
        Slot slot = this.getSlot(mouseX, mouseY);
        if (slot != null && slot instanceof IMEFluidSlot && slot.func_111238_b() && (fluidSlot = (IMEFluidSlot)slot).getAEFluidStack() != null && fluidSlot.shouldRenderAsFluid()) {
            IAEFluidStack fluidStack = fluidSlot.getAEFluidStack();
            String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format((double)fluidStack.getStackSize() / 1000.0) + " B";
            String modName = "" + TextFormatting.BLUE + TextFormatting.ITALIC + ((ModContainer)Loader.instance().getIndexedModList().get(Platform.getModId((IAEFluidStack)fluidStack))).getName();
            ArrayList<String> list = new ArrayList<String>();
            list.add(fluidStack.getFluidStack().getLocalizedName());
            list.add(formattedAmount);
            list.add(modName);
            this.func_146283_a(list, mouseX, mouseY);
            return;
        }
        super.func_191948_b(mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        if (btn instanceof GuiImgButton) {
            boolean backwards = Mouse.isButtonDown((int)1);
            GuiImgButton iBtn = (GuiImgButton)btn;
            if (iBtn.getSetting() != Settings.ACTIONS) {
                Enum cv = iBtn.getCurrentValue();
                Enum next = Platform.rotateEnum((Enum)cv, (boolean)backwards, (EnumSet)iBtn.getSetting().getPossibleValues());
                ModNetworking.instance().sendToServer(new PacketValueConfig(iBtn.getSetting().name(), next.name()));
                iBtn.set(next);
            }
        }
        if (btn == this.autoConsumeBoostersBox) {
            this.autoConsumeBoostersBox.cycleValue();
        }
        super.func_146284_a(btn);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && GuiWFT.func_146272_n()) {
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.mouseWheelEvent(x, y, i / Math.abs(i));
        }
    }

    private void mouseWheelEvent(int x, int y, int wheel) {
        Slot slot = this.getSlot(x, y);
        if (slot instanceof SlotFluidME) {
            IAEFluidStack stack = ((SlotFluidME)slot).getAEFluidStack();
            if (this.field_147002_h instanceof ContainerWFT) {
                ((ContainerWFT)this.field_147002_h).setTargetStack(stack);
                InventoryAction direction = wheel > 0 ? InventoryAction.ROLL_DOWN : InventoryAction.ROLL_UP;
                int times = Math.abs(wheel);
                int inventorySize = this.getInventorySlots().size();
                for (int h = 0; h < times; ++h) {
                    PacketInventoryAction p = new PacketInventoryAction(direction, inventorySize, 0L);
                    ModNetworking.instance().sendToServer(p);
                }
            }
        }
    }

    protected void func_184098_a(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof SlotFluidME) {
            SlotFluidME meSlot = (SlotFluidME)slot;
            if (clickType == ClickType.PICKUP) {
                if (mouseButton == 0 && meSlot.func_75216_d()) {
                    this.container.setTargetStack(meSlot.getAEFluidStack());
                    ModNetworking.instance().sendToServer(new PacketInventoryAction(InventoryAction.FILL_ITEM, slot.field_75222_d, 0L));
                } else if (!this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    this.container.setTargetStack(meSlot.getAEFluidStack());
                    ModNetworking.instance().sendToServer(new PacketInventoryAction(InventoryAction.EMPTY_ITEM, slot.field_75222_d, 0L));
                }
            }
            return;
        }
        if (clickType == ClickType.QUICK_MOVE && slot.func_75216_d()) {
            FluidStack fStack;
            IFluidTankProperties props;
            ItemStack stack = slot.func_75211_c();
            IFluidHandlerItem fh = FluidUtil.getFluidHandler((ItemStack)stack);
            if (!stack.func_190926_b() && fh != null && fh != null && (props = fh.getTankProperties()[0]) != null && (fStack = props.getContents()) != null && fStack.amount > 0) {
                ModNetworking.instance().sendToServer(new PacketInventoryAction(InventoryAction.SHIFT_CLICK, slot.field_75222_d, 0L));
            }
        }
        super.func_184098_a(slot, slotIdx, mouseButton, clickType);
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key)) {
            if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
                return;
            }
            if (this.searchField.func_146201_a(character, key)) {
                this.repo.setSearchString(this.searchField.func_146179_b());
                this.repo.updateView();
                this.setScrollBar();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        Enum searchMode = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_MODE);
        if (searchMode != SearchBoxMode.AUTOSEARCH && searchMode != SearchBoxMode.JEI_AUTOSEARCH) {
            this.searchField.func_146192_a(xCoord, yCoord, btn);
        }
        if (btn == 1 && this.searchField.isMouseIn(xCoord, yCoord)) {
            this.searchField.func_146180_a("");
            this.repo.setSearchString("");
            this.repo.updateView();
            this.setScrollBar();
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    public void postUpdate(List<IAEFluidStack> list) {
        for (IAEFluidStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        this.getScrollBar().setTop(18).setLeft(175).setHeight(88);
        this.getScrollBar().setRange(0, (this.repo.size() + 9 - 1) / 9 - 5, Math.max(1, 0));
    }

    public Enum getSortBy() {
        return this.configSrc.getSetting(Settings.SORT_BY);
    }

    public Enum getSortDir() {
        return this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    public Enum getSortDisplay() {
        return this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.sortByBox != null) {
            this.sortByBox.set(this.configSrc.getSetting(Settings.SORT_BY));
        }
        if (this.sortDirBox != null) {
            this.sortDirBox.set(this.configSrc.getSetting(Settings.SORT_DIRECTION));
        }
        this.repo.updateView();
    }

    protected List<SlotFluidME> getMeFluidSlots() {
        return this.meFluidSlots;
    }

    protected boolean isPowered() {
        return this.repo.hasPower();
    }

    protected String getBackground() {
        return "gui/fluid.png";
    }
}

