/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.RotorBladeState;
import erogenousbeef.bigreactors.common.multiblock.RotorShaftState;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTurbineRotorBlade;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTurbineRotorShaft;
import erogenousbeef.bigreactors.common.multiblock.helpers.RotorInfo;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePart;
import erogenousbeef.bigreactors.init.BrBlocks;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTurbineRotorBearing
extends TileEntityTurbinePart {
    RotorInfo rotorInfo = null;
    Integer displayList = null;
    float angle = 0.0f;
    protected AxisAlignedBB _renderBoundingBox;

    @SideOnly(value=Side.CLIENT)
    public Integer getDisplayList() {
        return this.displayList;
    }

    @SideOnly(value=Side.CLIENT)
    public void setDisplayList(int newList) {
        this.displayList = newList;
    }

    @SideOnly(value=Side.CLIENT)
    public void clearDisplayList() {
        this.displayList = null;
    }

    @SideOnly(value=Side.CLIENT)
    public float getAngle() {
        return this.angle;
    }

    @SideOnly(value=Side.CLIENT)
    public void setAngle(float newAngle) {
        this.angle = newAngle;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        long distance = 16 * FMLClientHandler.instance().getClient().field_71474_y.field_151451_c;
        return distance * distance;
    }

    public void onPostMachineAssembled(MultiblockControllerBase controller) {
        super.onPostMachineAssembled(controller);
        this.displayList = null;
        this.calculateRotorInfo();
    }

    @SideOnly(value=Side.CLIENT)
    public RotorInfo getRotorInfo() {
        if (null == this.rotorInfo && this.isConnected() && this.getMultiblockController().isAssembled()) {
            this.calculateRotorInfo();
        }
        return this.rotorInfo;
    }

    @SideOnly(value=Side.CLIENT)
    public void resetRotorInfo() {
        this.clearDisplayList();
        this.rotorInfo = null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return null != this._renderBoundingBox ? this._renderBoundingBox : super.getRenderBoundingBox();
    }

    private void calculateRotorInfo() {
        BlockTurbineRotorShaft turbineRotorShaft = BrBlocks.turbineRotorShaft;
        BlockTurbineRotorBlade turbineRotorBlade = BrBlocks.turbineRotorBlade;
        MultiblockTurbine turbine = this.getTurbine();
        BlockPos minCoord = turbine.getMinimumCoord();
        BlockPos maxCoord = turbine.getMaximumCoord();
        World world = this.func_145831_w();
        this._renderBoundingBox = new AxisAlignedBB((double)minCoord.func_177958_n(), (double)minCoord.func_177956_o(), (double)minCoord.func_177952_p(), (double)(maxCoord.func_177958_n() + 1), (double)(maxCoord.func_177956_o() + 1), (double)(maxCoord.func_177952_p() + 1));
        if (WorldHelper.calledByLogicalClient((World)world)) {
            EnumFacing direction = this.getOutwardFacing();
            EnumFacing.Axis shaftAxis = direction.func_176740_k();
            RotorInfo info = this.rotorInfo = new RotorInfo();
            info.x = this.func_174877_v().func_177958_n();
            info.y = this.func_174877_v().func_177956_o();
            info.z = this.func_174877_v().func_177952_p();
            info.rotorDirection = direction.func_176734_d();
            switch (shaftAxis) {
                case Y: {
                    info.rotorLength = maxCoord.func_177956_o() - minCoord.func_177956_o() - 1;
                    break;
                }
                case X: {
                    info.rotorLength = maxCoord.func_177958_n() - minCoord.func_177958_n() - 1;
                    break;
                }
                case Z: {
                    info.rotorLength = maxCoord.func_177952_p() - minCoord.func_177952_p() - 1;
                }
            }
            BlockPos currentCoord = this.getWorldPosition().func_177972_a(info.rotorDirection);
            EnumFacing[] dirsToCheck = RotorShaftState.getBladesDirections(shaftAxis);
            int rotorPosition = 0;
            info.bladeLengths = new int[info.rotorLength][4];
            info.shaftStates = new RotorShaftState[info.rotorLength];
            info.bladeStates = new RotorBladeState[info.rotorLength][4];
            while (rotorPosition < info.rotorLength) {
                IBlockState state = world.func_180495_p(currentCoord);
                info.shaftStates[rotorPosition] = (RotorShaftState)((Object)turbineRotorShaft.buildActualStateInternal(state, (IBlockAccess)world, currentCoord, (MultiblockTileEntityBase)this, true).func_177229_b(Properties.ROTORSHAFTSTATE));
                for (int bladeIdx = 0; bladeIdx < dirsToCheck.length; ++bladeIdx) {
                    EnumFacing bladeDir = dirsToCheck[bladeIdx];
                    BlockPos bladeCoord = currentCoord.func_177972_a(bladeDir);
                    int bladeLength = 0;
                    RotorBladeState bladeState = null;
                    state = world.func_180495_p(bladeCoord);
                    if (turbineRotorBlade == state.func_177230_c()) {
                        bladeState = (RotorBladeState)((Object)turbineRotorBlade.buildActualStateInternal(state, (IBlockAccess)world, bladeCoord, (MultiblockTileEntityBase)this, true).func_177229_b(Properties.ROTORBLADESTATE));
                        while (bladeLength < 32 && turbineRotorBlade == world.func_180495_p(bladeCoord).func_177230_c()) {
                            ++bladeLength;
                            bladeCoord = bladeCoord.func_177972_a(bladeDir);
                        }
                    }
                    info.bladeLengths[rotorPosition][bladeIdx] = bladeLength;
                    info.bladeStates[rotorPosition][bladeIdx] = bladeState;
                }
                ++rotorPosition;
                currentCoord = currentCoord.func_177972_a(info.rotorDirection);
            }
        }
    }
}

