/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.block;

import crafttweaker.api.block.BlockPatternOr;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.block.IBlockPattern;
import crafttweaker.api.data.IData;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;

public class MCSpecificBlock
implements IBlock {
    private final Block block;
    private final int meta;

    public MCSpecificBlock(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    private static String getBlockId(Block block) {
        return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
    }

    @Override
    public IBlockDefinition getDefinition() {
        return CraftTweakerMC.getBlockDefinition(this.block);
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    @Override
    public IData getTileData() {
        return null;
    }

    @Override
    public List<IBlock> getBlocks() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean matches(IBlock block) {
        return block.getDefinition() == this.getDefinition() && (this.meta == Short.MAX_VALUE || block.getMeta() == this.meta);
    }

    @Override
    public IBlockPattern or(IBlockPattern pattern) {
        return new BlockPatternOr(this, pattern);
    }

    @Override
    public String getDisplayName() {
        return this.block.func_149732_F();
    }

    public String toString() {
        return "<block:" + MCSpecificBlock.getBlockId(this.block) + ":" + (this.meta == Short.MAX_VALUE ? 42 : this.meta) + ">";
    }
}

