/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.formatting;

import crafttweaker.api.formatting.IFormattedText;
import crafttweaker.mc1120.formatting.IMCFormattedString;
import java.util.Arrays;
import net.minecraft.util.text.TextFormatting;

public class FormattedStringJoin
implements IMCFormattedString {
    private final IMCFormattedString[] values;

    public FormattedStringJoin(IMCFormattedString first, IMCFormattedString second) {
        this.values = new IMCFormattedString[]{first, second};
    }

    public FormattedStringJoin(IMCFormattedString[] values) {
        this.values = values;
    }

    @Override
    public String getTooltipString() {
        StringBuilder result = new StringBuilder();
        for (IMCFormattedString value : this.values) {
            result.append(value.getTooltipString());
        }
        return result.toString();
    }

    @Override
    public String getTooltipString(String context) {
        boolean first = true;
        StringBuilder result = new StringBuilder();
        for (IMCFormattedString value : this.values) {
            if (first) {
                first = false;
            } else {
                result.append(context);
            }
            result.append(value.getTooltipString());
            result.append(TextFormatting.RESET);
        }
        return result.toString();
    }

    @Override
    public IFormattedText add(IFormattedText other) {
        return this.cat(other);
    }

    @Override
    public IFormattedText cat(IFormattedText other) {
        IMCFormattedString[] newValues = Arrays.copyOf(this.values, this.values.length + 1);
        newValues[this.values.length] = (IMCFormattedString)other;
        return new FormattedStringJoin(newValues);
    }

    @Override
    public String getText() {
        return this.getTooltipString();
    }
}

