/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.parsing.SingleArg;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;

public final class CommandArgs {
    private final String rawInput;
    private List<SingleArg> args;
    private int index = -1;

    public CommandArgs(String rawInput, List<SingleArg> args) {
        this.rawInput = rawInput;
        this.args = new ArrayList<SingleArg>(args);
    }

    public boolean hasNext() {
        return this.index + 1 < this.args.size();
    }

    public String peek() throws ArgumentParseException {
        if (!this.hasNext()) {
            throw this.createError(SpongeApiTranslationHelper.t("Not enough arguments", new Object[0]));
        }
        return this.args.get(this.index + 1).getValue();
    }

    public String next() throws ArgumentParseException {
        if (!this.hasNext()) {
            throw this.createError(SpongeApiTranslationHelper.t("Not enough arguments!", new Object[0]));
        }
        return this.args.get(++this.index).getValue();
    }

    public Optional<String> nextIfPresent() {
        return this.hasNext() ? Optional.of(this.args.get(++this.index).getValue()) : Optional.empty();
    }

    public ArgumentParseException createError(Text message) {
        return new ArgumentParseException(message, this.rawInput, this.index < 0 ? 0 : this.args.get(this.index).getStartIdx());
    }

    public List<String> getAll() {
        return Collections.unmodifiableList(this.args.stream().map(SingleArg::getValue).collect(Collectors.toList()));
    }

    List<SingleArg> getArgs() {
        return this.args;
    }

    @Deprecated
    public Object getState() {
        return this.getSnapshot();
    }

    @Deprecated
    public void setState(Object state) {
        if (!(state instanceof Snapshot)) {
            throw new IllegalArgumentException("Provided state was not of appropriate format returned by getState!");
        }
        this.applySnapshot((Snapshot)state, false);
    }

    public String getRaw() {
        return this.rawInput;
    }

    public void insertArg(String value) {
        int index = this.index < 0 ? 0 : this.args.get(this.index).getEndIdx();
        this.args.add(this.index + 1, new SingleArg(value, index, index));
    }

    @Deprecated
    public void removeArgs(Object startState, Object endState) {
        if (!(startState instanceof Integer) || !(endState instanceof Integer)) {
            throw new IllegalArgumentException("One of the states provided was not of the correct type!");
        }
        this.removeArgs((Integer)startState, (Integer)endState);
    }

    public void removeArgs(Snapshot startSnapshot, Snapshot endSnapshot) {
        this.removeArgs(startSnapshot.index, endSnapshot.index);
    }

    private void removeArgs(int startIdx, int endIdx) {
        if (this.index >= startIdx) {
            this.index = this.index < endIdx ? startIdx - 1 : (this.index -= endIdx - startIdx + 1);
        }
        for (int i = startIdx; i <= endIdx; ++i) {
            this.args.remove(startIdx);
        }
    }

    void previous() {
        if (this.index > -1) {
            --this.index;
        }
    }

    public int getRawPosition() {
        return this.index < 0 ? 0 : this.args.get(this.index).getStartIdx();
    }

    public Snapshot getSnapshot() {
        return new Snapshot(this.index, this.args);
    }

    public void applySnapshot(Snapshot snapshot) {
        this.applySnapshot(snapshot, true);
    }

    public void applySnapshot(Snapshot snapshot, boolean resetArgs) {
        this.index = snapshot.index;
        if (resetArgs) {
            this.args.clear();
            this.args.addAll((Collection<SingleArg>)snapshot.args);
        }
    }

    public final class Snapshot {
        final int index;
        final ImmutableList<SingleArg> args;

        Snapshot(int index, List<SingleArg> args) {
            this.index = index;
            this.args = ImmutableList.copyOf(args);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Snapshot snapshot = (Snapshot)o;
            return this.index == snapshot.index && Objects.equals(this.args, snapshot.args);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.args);
        }
    }
}

