/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.EntityLiving;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableDominantHandData;
import org.spongepowered.api.data.manipulator.mutable.entity.DominantHandData;
import org.spongepowered.api.data.type.HandPreference;
import org.spongepowered.api.data.type.HandPreferences;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeDominantHandData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class DominantHandDataProcessor
extends AbstractEntitySingleDataProcessor<EntityLiving, HandPreference, Value<HandPreference>, DominantHandData, ImmutableDominantHandData> {
    public DominantHandDataProcessor() {
        super(EntityLiving.class, Keys.DOMINANT_HAND);
    }

    @Override
    protected boolean set(EntityLiving dataHolder, HandPreference value) {
        dataHolder.func_184641_n(value.equals(HandPreferences.LEFT));
        return true;
    }

    @Override
    protected Optional<HandPreference> getVal(EntityLiving dataHolder) {
        return Optional.of((HandPreference)dataHolder.func_184591_cq());
    }

    @Override
    protected ImmutableValue<HandPreference> constructImmutableValue(HandPreference value) {
        return ImmutableSpongeValue.cachedOf(Keys.DOMINANT_HAND, DataConstants.Catalog.DEFAULT_HAND, value);
    }

    @Override
    protected Value<HandPreference> constructValue(HandPreference actualValue) {
        return new SpongeValue<HandPreference>(Keys.DOMINANT_HAND, DataConstants.Catalog.DEFAULT_HAND, actualValue);
    }

    @Override
    protected DominantHandData createManipulator() {
        return new SpongeDominantHandData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

