/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.Optional;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableColoredData;
import org.spongepowered.api.data.manipulator.mutable.ColoredData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.data.manipulator.mutable.SpongeColoredData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.util.ColorUtil;

public class ColoredDataProcessor
extends AbstractItemSingleDataProcessor<Color, Value<Color>, ColoredData, ImmutableColoredData> {
    public ColoredDataProcessor() {
        super(ColorUtil::hasColor, Keys.COLOR);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (this.supports(container)) {
            ItemStack stack = (ItemStack)container;
            Optional<Color> old = this.getVal(stack);
            if (!old.isPresent()) {
                return DataTransactionResult.successNoData();
            }
            if (!ColorUtil.hasColorInNbt(stack)) {
                return DataTransactionResult.failNoData();
            }
            NbtDataUtil.removeColorFromNBT(stack);
            return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean set(ItemStack container, Color value) {
        if (!this.supports(container)) {
            return false;
        }
        ColorUtil.setItemStackColor(container, value);
        return true;
    }

    @Override
    protected Optional<Color> getVal(ItemStack container) {
        return ColorUtil.getItemStackColor(container);
    }

    @Override
    protected Value<Color> constructValue(Color actualValue) {
        return new SpongeValue<Color>(Keys.COLOR, Color.BLACK, actualValue);
    }

    @Override
    protected ImmutableValue<Color> constructImmutableValue(Color value) {
        return ImmutableSpongeValue.cachedOf(Keys.COLOR, Color.BLACK, value);
    }

    @Override
    protected ColoredData createManipulator() {
        return new SpongeColoredData();
    }
}

