/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutablePlainPagedData;
import org.spongepowered.api.data.manipulator.mutable.item.PlainPagedData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.common.data.manipulator.mutable.item.SpongePlainPagedData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class ItemPlainPagedDataProcessor
extends AbstractItemSingleDataProcessor<List<String>, ListValue<String>, PlainPagedData, ImmutablePlainPagedData> {
    public ItemPlainPagedDataProcessor() {
        super((ItemStack input) -> input.func_77973_b() == Items.field_151099_bA, Keys.PLAIN_BOOK_PAGES);
    }

    @Override
    public Optional<PlainPagedData> fill(DataContainer container, PlainPagedData pagedData) {
        List pages = DataUtil.getData((DataView)container, Keys.PLAIN_BOOK_PAGES, List.class);
        return Optional.of(pagedData.set(Keys.PLAIN_BOOK_PAGES, pages));
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (this.supports(container)) {
            ItemStack stack = (ItemStack)container;
            Optional<List<String>> old = this.getVal(stack);
            if (!old.isPresent()) {
                return DataTransactionResult.successNoData();
            }
            NbtDataUtil.removePagesFromNBT(stack);
            return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected PlainPagedData createManipulator() {
        return new SpongePlainPagedData();
    }

    @Override
    protected boolean set(ItemStack itemStack, List<String> value) {
        NbtDataUtil.setPlainPagesToNBT(itemStack, value);
        return true;
    }

    @Override
    protected Optional<List<String>> getVal(ItemStack itemStack) {
        if (!itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("pages")) {
            return Optional.empty();
        }
        return Optional.of(NbtDataUtil.getPlainPagesFromNBT(ItemStackUtil.getTagCompound(itemStack)));
    }

    @Override
    protected ListValue<String> constructValue(List<String> actualValue) {
        return new SpongeListValue<String>(Keys.PLAIN_BOOK_PAGES, actualValue);
    }

    @Override
    protected ImmutableValue<List<String>> constructImmutableValue(List<String> value) {
        return new ImmutableSpongeListValue<String>(Keys.PLAIN_BOOK_PAGES, ImmutableList.copyOf(value));
    }
}

