/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.BlockItemDropsSupplier;
import org.spongepowered.common.event.tracking.context.BlockItemEntityDropsSupplier;
import org.spongepowered.common.event.tracking.context.CaptureBlockPos;
import org.spongepowered.common.event.tracking.context.CapturedBlockEntitySpawnSupplier;
import org.spongepowered.common.event.tracking.context.CapturedBlocksSupplier;
import org.spongepowered.common.event.tracking.context.CapturedEntitiesSupplier;
import org.spongepowered.common.event.tracking.context.CapturedItemStackSupplier;
import org.spongepowered.common.event.tracking.context.CapturedItemsSupplier;
import org.spongepowered.common.event.tracking.context.CapturedMultiMapSupplier;
import org.spongepowered.common.event.tracking.context.CapturedSupplier;
import org.spongepowered.common.event.tracking.context.EntityItemDropsSupplier;
import org.spongepowered.common.event.tracking.context.EntityItemEntityDropsSupplier;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.context.ICaptureSupplier;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.interfaces.entity.player.IMixinInventoryPlayer;

public class PhaseContext<P extends PhaseContext<P>>
implements AutoCloseable {
    @Nullable
    private static PhaseContext<?> EMPTY;
    @Nullable
    BlockSnapshot neighborNotificationSource;
    protected final IPhaseState<? extends P> state;
    protected boolean isCompleted = false;
    @Nullable
    private StackTraceElement[] stackTrace;
    @Nullable
    private CapturedBlocksSupplier blocksSupplier;
    @Nullable
    private CapturedItemsSupplier capturedItemsSupplier;
    @Nullable
    private CapturedEntitiesSupplier capturedEntitiesSupplier;
    @Nullable
    private CapturedItemStackSupplier capturedItemStackSupplier;
    @Nullable
    private CapturedMultiMapSupplier<BlockPos, net.minecraft.entity.Entity> blockEntitySpawnSupplier;
    @Nullable
    private BlockItemDropsSupplier blockItemDropsSupplier;
    @Nullable
    private BlockItemEntityDropsSupplier blockItemEntityDropsSupplier;
    @Nullable
    private CaptureBlockPos captureBlockPos;
    @Nullable
    private EntityItemDropsSupplier entityItemDropsSupplier;
    @Nullable
    private EntityItemEntityDropsSupplier entityItemEntityDropsSupplier;
    @Nullable
    protected User owner;
    @Nullable
    protected User notifier;
    private boolean processImmediately;
    private boolean allowsBlockEvents = true;
    private boolean allowsEntityEvents = true;
    private boolean allowsBulkBlockCaptures = true;
    private boolean allowsBulkEntityCaptures = true;
    @Nullable
    Deque<CauseStackManager.StackFrame> usedFrame;
    @Nullable
    private Object source;

    public static PhaseContext<?> empty() {
        if (EMPTY == null) {
            EMPTY = new GeneralizedContext((IPhaseState<? extends GeneralizedContext>)GeneralPhase.State.COMPLETE).markEmpty();
        }
        return EMPTY;
    }

    public P source(Object owner) {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        this.source = owner;
        return (P)this;
    }

    public P owner(Supplier<Optional<User>> supplier) {
        supplier.get().ifPresent(this::owner);
        return (P)this;
    }

    public P owner(User owner) {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        if (this.owner != null) {
            throw new IllegalStateException("Owner for this phase context is already set!");
        }
        this.owner = (User)Preconditions.checkNotNull((Object)owner, (Object)"Owner cannot be null!");
        return (P)this;
    }

    public P notifier(Supplier<Optional<User>> supplier) {
        supplier.get().ifPresent(this::notifier);
        return (P)this;
    }

    public P notifier(User notifier) {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        if (this.notifier != null) {
            throw new IllegalStateException("Notifier for this phase context is already set!");
        }
        this.notifier = (User)Preconditions.checkNotNull((Object)notifier, (Object)"Notifier cannot be null!");
        return (P)this;
    }

    private void checkBlockSuppliers() {
        Preconditions.checkState((this.blocksSupplier == null ? 1 : 0) != 0, (Object)"BlocksSuppler is already set!");
        Preconditions.checkState((this.blockItemEntityDropsSupplier == null ? 1 : 0) != 0, (Object)"BlockItemEntityDropsSupplier is already set!");
        Preconditions.checkState((this.blockItemDropsSupplier == null ? 1 : 0) != 0, (Object)"BlockItemDropsSupplier is already set!");
        Preconditions.checkState((this.blockEntitySpawnSupplier == null ? 1 : 0) != 0, (Object)"BlockEntitySpawnSupplier is already set!");
        Preconditions.checkState((this.captureBlockPos == null ? 1 : 0) != 0, (Object)"CaptureBlockPos is already set!");
    }

    public P addBlockCaptures() {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        this.checkBlockSuppliers();
        this.blocksSupplier = new CapturedBlocksSupplier();
        this.blockItemEntityDropsSupplier = new BlockItemEntityDropsSupplier();
        this.blockItemDropsSupplier = new BlockItemDropsSupplier();
        this.blockEntitySpawnSupplier = new CapturedBlockEntitySpawnSupplier();
        this.captureBlockPos = new CaptureBlockPos();
        return (P)this;
    }

    public P addCaptures() {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        this.addBlockCaptures();
        this.addEntityCaptures();
        return (P)this;
    }

    public P addEntityCaptures() {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        Preconditions.checkState((this.capturedItemsSupplier == null ? 1 : 0) != 0, (Object)"CapturedItemsSupplier is already set!");
        Preconditions.checkState((this.capturedEntitiesSupplier == null ? 1 : 0) != 0, (Object)"CapturedEntitiesSupplier is already set!");
        Preconditions.checkState((this.capturedItemStackSupplier == null ? 1 : 0) != 0, (Object)"CapturedItemStackSupplier is already set!");
        this.capturedItemsSupplier = new CapturedItemsSupplier();
        this.capturedEntitiesSupplier = new CapturedEntitiesSupplier();
        this.capturedItemStackSupplier = new CapturedItemStackSupplier();
        return (P)this;
    }

    public P addEntityDropCaptures() {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        Preconditions.checkState((this.entityItemDropsSupplier == null ? 1 : 0) != 0, (Object)"EntityItemDropsSupplier is already set!");
        Preconditions.checkState((this.entityItemEntityDropsSupplier == null ? 1 : 0) != 0, (Object)"EntityItemEntityDropsSupplier is already set!");
        this.entityItemDropsSupplier = new EntityItemDropsSupplier();
        this.entityItemEntityDropsSupplier = new EntityItemEntityDropsSupplier();
        return (P)this;
    }

    public P setBulkBlockCaptures(boolean captures) {
        this.allowsBulkBlockCaptures = captures;
        return (P)this;
    }

    public boolean allowsBulkBlockCaptures() {
        return this.allowsBulkBlockCaptures;
    }

    public P setBlockEvents(boolean events) {
        this.allowsBlockEvents = events;
        return (P)this;
    }

    public boolean allowsBlockEvents() {
        return this.allowsBlockEvents;
    }

    protected P setEntitySpawnEvents(boolean b) {
        this.allowsEntityEvents = b;
        return (P)this;
    }

    public boolean allowsEntityEvents() {
        return this.allowsEntityEvents;
    }

    protected P setBulkEntityCaptures(boolean b) {
        this.allowsBulkEntityCaptures = b;
        return (P)this;
    }

    public boolean allowsBulkEntityCaptures() {
        return this.allowsBulkEntityCaptures;
    }

    public P buildAndSwitch() {
        this.isCompleted = true;
        if (SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().generateStackTracePerStateEntry()) {
            this.stackTrace = new Exception("Debug Trace").getStackTrace();
        }
        PhaseTracker.getInstance().switchToPhase(this.state, this);
        return (P)this;
    }

    public boolean isComplete() {
        return this.isCompleted;
    }

    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        if (this.owner != null) {
            printer.add(s + "- %s: %s", "Owner", this.owner);
        }
        if (this.source != null) {
            printer.add(s + "- %s: %s", "Source", this.source);
        }
        if (this.blocksSupplier != null && !this.blocksSupplier.isEmpty()) {
            printer.add(s + "- %s: %s", "CapturedBlocks", this.blocksSupplier);
        }
        if (this.blockItemDropsSupplier != null && !this.blockItemDropsSupplier.isEmpty()) {
            printer.add(s + "- %s: %s", "BlockItemDrops", this.blockItemDropsSupplier);
        }
        if (this.blockItemEntityDropsSupplier != null && !this.blockItemEntityDropsSupplier.isEmpty()) {
            printer.add(s + "- %s: %s", "BlockItemEntityDrops", this.blockItemEntityDropsSupplier);
        }
        if (this.capturedItemsSupplier != null && !this.capturedItemsSupplier.isEmpty()) {
            printer.add(s + "- %s: %s", "CapturedItems", this.capturedItemsSupplier);
        }
        if (this.capturedEntitiesSupplier != null && !this.capturedEntitiesSupplier.isEmpty()) {
            printer.add(s + "- %s: %s", "CapturedEntities", this.capturedEntitiesSupplier);
        }
        if (this.capturedItemStackSupplier != null && !this.capturedItemStackSupplier.isEmpty()) {
            printer.add(s + "- %s: %s", "CapturedItemStack", this.capturedItemStackSupplier);
        }
        if (this.entityItemDropsSupplier != null && !this.entityItemDropsSupplier.isEmpty()) {
            printer.add(s + "- %s: %s", "EntityItemDrops", this.entityItemDropsSupplier);
        }
        if (this.entityItemEntityDropsSupplier != null && !this.entityItemEntityDropsSupplier.isEmpty()) {
            printer.add(s + "- %s: %s", "EntityItemEntityDrops", this.entityItemEntityDropsSupplier);
        }
        if (this.blockEntitySpawnSupplier != null && !this.blockEntitySpawnSupplier.isEmpty()) {
            printer.add(s + "- %s: %s", "BlockEntitySpawns", this.blockEntitySpawnSupplier);
        }
        if (this.captureBlockPos != null) {
            printer.add(s + "- %s: %s", "CapturedBlockPosition", this.captureBlockPos);
        }
        return printer;
    }

    public boolean notAllCapturesProcessed() {
        return this.isNonEmpty(this.blocksSupplier) || this.isNonEmpty(this.blockItemDropsSupplier) || this.isNonEmpty(this.blockItemEntityDropsSupplier) || this.isNonEmpty(this.capturedItemsSupplier) || this.isNonEmpty(this.capturedEntitiesSupplier) || this.isNonEmpty(this.capturedItemStackSupplier) || this.isNonEmpty(this.entityItemDropsSupplier) || this.isNonEmpty(this.entityItemEntityDropsSupplier) || this.isNonEmpty(this.blockEntitySpawnSupplier);
    }

    private boolean isNonEmpty(@Nullable ICaptureSupplier supplier) {
        return supplier != null && !supplier.isEmpty();
    }

    public boolean shouldProcessImmediately() {
        return this.processImmediately;
    }

    public void setProcessImmediately(boolean state) {
        this.processImmediately = state;
    }

    public <T> Optional<T> getSource(Class<T> sourceClass) {
        if (this.source == null) {
            return Optional.empty();
        }
        if (sourceClass.isInstance(this.source)) {
            return Optional.of(this.source);
        }
        return Optional.empty();
    }

    @Nullable
    public Object getSource() {
        return this.source;
    }

    public <T> T requireSource(Class<T> targetClass) {
        return this.getSource(targetClass).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", this));
    }

    public Optional<User> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public boolean applyOwnerIfAvailable(Consumer<User> consumer) {
        if (this.owner != null) {
            consumer.accept(this.owner);
            return true;
        }
        return false;
    }

    public Optional<User> getNotifier() {
        return Optional.ofNullable(this.notifier);
    }

    public boolean applyNotifierIfAvailable(Consumer<User> consumer) {
        if (this.notifier != null) {
            consumer.accept(this.notifier);
            return true;
        }
        return false;
    }

    public List<Entity> getCapturedEntities() throws IllegalStateException {
        if (this.capturedEntitiesSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture entity spawns!", this).get();
        }
        return this.capturedEntitiesSupplier.get();
    }

    public CapturedSupplier<Entity> getCapturedEntitySupplier() throws IllegalStateException {
        if (this.capturedEntitiesSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture entity spawns!", this).get();
        }
        return this.capturedEntitiesSupplier;
    }

    public List<EntityItem> getCapturedItems() throws IllegalStateException {
        if (this.capturedItemsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture dropped item entities!", this).get();
        }
        return this.capturedItemsSupplier.get();
    }

    public CapturedSupplier<EntityItem> getCapturedItemsSupplier() throws IllegalStateException {
        if (this.capturedItemsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture dropped item entities!", this).get();
        }
        return this.capturedItemsSupplier;
    }

    public List<BlockSnapshot> getCapturedBlocks() throws IllegalStateException {
        if (this.blocksSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing blocks, but we're not capturing them!", this).get();
        }
        return this.blocksSupplier.get();
    }

    public CapturedSupplier<BlockSnapshot> getCapturedBlockSupplier() throws IllegalStateException {
        if (this.blocksSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing blocks, but we're not capturing them!", this).get();
        }
        return this.blocksSupplier;
    }

    public CapturedMultiMapSupplier<BlockPos, ItemDropData> getBlockDropSupplier() throws IllegalStateException {
        if (this.blockItemDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing block drops!", this).get();
        }
        return this.blockItemDropsSupplier;
    }

    public CapturedMultiMapSupplier<BlockPos, EntityItem> getBlockItemDropSupplier() throws IllegalStateException {
        if (this.blockItemEntityDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to track block item drops!", this).get();
        }
        return this.blockItemEntityDropsSupplier;
    }

    public CapturedMultiMapSupplier<UUID, ItemDropData> getPerEntityItemDropSupplier() throws IllegalStateException {
        if (this.entityItemDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture entity drops!", this).get();
        }
        return this.entityItemDropsSupplier;
    }

    public CapturedMultiMapSupplier<UUID, EntityItem> getPerEntityItemEntityDropSupplier() throws IllegalStateException {
        if (this.entityItemEntityDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture entity drops!", this).get();
        }
        return this.entityItemEntityDropsSupplier;
    }

    public CapturedSupplier<ItemDropData> getCapturedItemStackSupplier() throws IllegalStateException {
        if (this.capturedItemStackSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing ItemStack drops from entities!", this).get();
        }
        return this.capturedItemStackSupplier;
    }

    public CapturedMultiMapSupplier<BlockPos, net.minecraft.entity.Entity> getPerBlockEntitySpawnSuppplier() throws IllegalStateException {
        if (this.blockEntitySpawnSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to track block entity spawns!", this).get();
        }
        return this.blockEntitySpawnSupplier;
    }

    public CaptureBlockPos getCaptureBlockPos() throws IllegalStateException {
        if (this.captureBlockPos == null) {
            throw TrackingUtil.throwWithContext("Intended to capture a block position!", this).get();
        }
        return this.captureBlockPos;
    }

    public boolean hasCaptures() {
        if (this.blocksSupplier != null && !this.blocksSupplier.isEmpty()) {
            return true;
        }
        if (this.blockEntitySpawnSupplier != null && !this.blockEntitySpawnSupplier.isEmpty()) {
            return true;
        }
        if (this.blockItemDropsSupplier != null && !this.blockItemDropsSupplier.isEmpty()) {
            return true;
        }
        if (this.blockItemEntityDropsSupplier != null && !this.blockItemEntityDropsSupplier.isEmpty()) {
            return true;
        }
        if (this.capturedEntitiesSupplier != null && !this.capturedEntitiesSupplier.isEmpty()) {
            return true;
        }
        if (this.capturedItemsSupplier != null && !this.capturedItemsSupplier.isEmpty()) {
            return true;
        }
        if (this.capturedItemStackSupplier != null && !this.capturedItemStackSupplier.isEmpty()) {
            return true;
        }
        if (this.entityItemDropsSupplier != null && !this.entityItemDropsSupplier.isEmpty()) {
            return true;
        }
        if (this.entityItemEntityDropsSupplier != null && !this.entityItemEntityDropsSupplier.isEmpty()) {
            return true;
        }
        return this.source != null && this.source instanceof EntityPlayer && ((IMixinInventoryPlayer)((EntityPlayer)this.source).field_71071_by).getCapturedTransactions().size() > 0;
    }

    public Optional<BlockPos> getBlockPosition() {
        return this.getCaptureBlockPos().getPos();
    }

    public void addNotifierAndOwnerToCauseStack(CauseStackManager.StackFrame frame) {
        if (this.owner != null) {
            frame.addContext(EventContextKeys.OWNER, this.owner);
        }
        if (this.notifier != null) {
            frame.addContext(EventContextKeys.NOTIFIER, this.notifier);
        }
    }

    protected PhaseContext(IPhaseState<? extends P> state) {
        this.state = state;
    }

    public int hashCode() {
        return Objects.hash(this.isCompleted);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PhaseContext other = (PhaseContext)obj;
        return Objects.equals(this.isCompleted, other.isCompleted);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("isCompleted", this.isCompleted).toString();
    }

    protected P markEmpty() {
        this.isCompleted = true;
        return (P)this;
    }

    private boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public void close() {
        if (this.isEmpty()) {
            PhaseTracker.getInstance().printMessageWithCaughtException("Closing an empty Phasecontext", "We should never be closing an empty phase context (or complete phase) This is likely an error from sponge.", new IllegalStateException("Closing empty phase context"));
            return;
        }
        PhaseTracker.getInstance().completePhase(this.state);
        if (this.usedFrame == null && SpongeImplHooks.isMainThread()) {
            SpongeImpl.getCauseStackManager().popFrameMutator(this);
        }
        if (this.usedFrame != null) {
            this.usedFrame.iterator().forEachRemaining(Sponge.getCauseStackManager()::popCauseFrame);
            this.usedFrame.clear();
            this.usedFrame = null;
        }
    }

    public List<BlockSnapshot> getCapturedBlocksOrEmptyList() {
        return this.blocksSupplier != null ? this.blocksSupplier.orEmptyList() : Collections.emptyList();
    }

    public List<Entity> getCapturedEntitiesOrEmptyList() {
        return this.capturedEntitiesSupplier != null ? this.capturedEntitiesSupplier.orEmptyList() : Collections.emptyList();
    }

    public List<EntityItem> getCapturedItemsOrEmptyList() {
        return this.capturedItemsSupplier != null ? this.capturedItemsSupplier.orEmptyList() : Collections.emptyList();
    }

    public boolean isCapturingBlockItemDrops() {
        return this.blockItemDropsSupplier != null || this.blockEntitySpawnSupplier != null;
    }

    public void printTrace(PrettyPrinter printer) {
        if (SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().generateStackTracePerStateEntry()) {
            printer.add("Entrypoint:").add(this.stackTrace);
        }
    }

    public boolean allowsBlockPosCapturing() {
        return this.captureBlockPos != null;
    }

    public boolean captureEntity(Entity entity) {
        if (this.captureBlockPos != null && this.captureBlockPos.getPos().isPresent() && this.blockEntitySpawnSupplier != null) {
            Optional<BlockPos> pos = this.captureBlockPos.getPos();
            if (entity instanceof EntityItem && this.blockItemEntityDropsSupplier != null) {
                return this.blockItemEntityDropsSupplier.get().get((Object)pos.get()).add((EntityItem)entity);
            }
            return this.blockEntitySpawnSupplier.get().get((Object)pos.get()).add(EntityUtil.toNative(entity));
        }
        if (entity instanceof EntityItem && this.capturedItemsSupplier != null) {
            return this.capturedItemsSupplier.get().add((EntityItem)entity);
        }
        if (this.capturedEntitiesSupplier != null) {
            return this.capturedEntitiesSupplier.get().add(entity);
        }
        throw new IllegalStateException("Expected to capture entities, but we aren't capturing them.");
    }

    @Nullable
    public User getActiveUser() {
        if (this.notifier != null) {
            return this.notifier;
        }
        if (this.owner != null) {
            return this.owner;
        }
        if (this.source != null && this.source instanceof User) {
            return (User)this.source;
        }
        return null;
    }

    @Nullable
    public BlockSnapshot getNeighborNotificationSource() {
        return this.neighborNotificationSource;
    }
}

