/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.NonNullList;
import org.spongepowered.common.event.tracking.context.ICaptureSupplier;

public abstract class CapturedSupplier<T>
implements Supplier<List<T>>,
ICaptureSupplier {
    @Nullable
    private List<T> captured;

    CapturedSupplier() {
    }

    @Override
    public final List<T> get() {
        if (this.captured == null) {
            this.captured = NonNullList.func_191196_a();
        }
        return this.captured;
    }

    @Override
    public final boolean isEmpty() {
        return this.captured == null || this.captured.isEmpty();
    }

    public final void acceptAndClearIfNotEmpty(Consumer<List<T>> consumer) {
        if (!this.isEmpty()) {
            ArrayList<T> consumed = new ArrayList<T>(this.captured);
            this.captured.clear();
            consumer.accept(consumed);
        }
    }

    public final List<T> orElse(List<T> list) {
        return this.isEmpty() ? list : this.captured;
    }

    public final List<T> orEmptyList() {
        return this.captured == null ? Collections.emptyList() : this.captured;
    }

    public final Stream<T> stream() {
        return this.captured == null ? Stream.empty() : this.captured.stream();
    }

    public int hashCode() {
        return Objects.hashCode(this.captured);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CapturedSupplier other = (CapturedSupplier)obj;
        return Objects.equals(this.captured, other.captured);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Captured", this.captured == null ? 0 : this.captured.size()).toString();
    }
}

