/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;

final class DispensePhaseState
extends BlockPhaseState {
    DispensePhaseState() {
    }

    @Override
    public GeneralizedContext createPhaseContext() {
        return (GeneralizedContext)((GeneralizedContext)((GeneralizedContext)super.createPhaseContext().addBlockCaptures()).addEntityCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(GeneralizedContext phaseContext) {
        phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
        phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DISPENSE);
            SpongeCommonEventFactory.callDropItemDispense(items, phaseContext);
        });
        phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DISPENSE);
            SpongeCommonEventFactory.callSpawnEntity(entities, phaseContext);
        });
    }
}

