/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;

final class ExplosionState
extends GeneralState<ExplosionContext> {
    public final BiConsumer<CauseStackManager.StackFrame, ExplosionContext> EXPLOSION_MODIFIER = super.getFrameModifier().andThen((frame, context) -> frame.pushCause(context.getExplosion()));

    ExplosionState() {
    }

    @Override
    public ExplosionContext createPhaseContext() {
        return ((ExplosionContext)((ExplosionContext)((ExplosionContext)new ExplosionContext().addEntityCaptures()).addEntityDropCaptures()).addBlockCaptures()).populateFromCurrentState();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, ExplosionContext> getFrameModifier() {
        return this.EXPLOSION_MODIFIER;
    }

    @Override
    public boolean canSwitchTo(IPhaseState<?> state) {
        return true;
    }

    @Override
    public boolean tracksBlockSpecificDrops(ExplosionContext context) {
        return true;
    }

    @Override
    public boolean requiresBlockPosTracking() {
        return true;
    }

    @Override
    public boolean alreadyCapturingEntitySpawns() {
        return true;
    }

    @Override
    public boolean alreadyProcessingBlockItemDrops() {
        return true;
    }

    @Override
    public boolean ignoresEntityCollisions() {
        return true;
    }

    @Override
    public void unwind(ExplosionContext context) {
        context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, context));
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            try (CauseStackManager.StackFrame smaller = Sponge.getCauseStackManager().pushCauseFrame();){
                smaller.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.TNT_IGNITE);
                SpongeCommonEventFactory.callSpawnEntity(entities, context);
            }
        });
    }

    @Override
    public ChangeBlockEvent.Post createChangeBlockPostEvent(ExplosionContext context, ImmutableList<Transaction<BlockSnapshot>> transactions) {
        return SpongeEventFactory.createExplosionEventPost(Sponge.getCauseStackManager().getCurrentCause(), context.getSpongeExplosion(), transactions);
    }

    @Override
    public boolean shouldCaptureBlockChangeOrSkip(ExplosionContext phaseContext, BlockPos pos) {
        return true;
    }

    @Override
    public boolean spawnEntityOrCapture(ExplosionContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        return context.getBlockPosition().map(blockPos -> {
            ArrayListMultimap<BlockPos, Entity> blockPosEntityMultimap = context.getPerBlockEntitySpawnSuppplier().get();
            ArrayListMultimap<BlockPos, EntityItem> blockPosEntityItemMultimap = context.getBlockItemDropSupplier().get();
            if (entity instanceof EntityItem) {
                blockPosEntityItemMultimap.put(blockPos, (Object)((EntityItem)entity));
            } else {
                blockPosEntityMultimap.put(blockPos, (Object)((Entity)entity));
            }
            return true;
        }).orElseGet(() -> {
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            entities.add(entity);
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                Boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
                return bl;
            }
        });
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return true;
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }
}

